/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.marker.resolution;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.annotations.SqlBindingIgnoreValidation;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.annotation.IgnoreSqlBindingAnnotationCreateOperation;
import org.eclipse.scout.sdk.sql.binding.SqlBindingMarkers;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.jdt.JdtUiUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.ui.IMarkerResolution;

public class SqlBindMarkerResolution
implements IMarkerResolution {
    private String[] m_bindings;

    public SqlBindMarkerResolution(String ... bindings) {
        this.m_bindings = bindings;
    }

    public String getLabel() {
        if (this.getBindings().length == 1) {
            return "Add ignore annotation for '" + this.getBindings()[0] + "'.";
        }
        return "Add ignore annotation for all bindings.";
    }

    public void run(IMarker marker) {
        String icuName = "";
        String bindVar = "";
        try {
            ICompilationUnit icu = (ICompilationUnit)JavaCore.create((IFile)((IFile)marker.getResource()));
            if (icu.getTypes().length > 0) {
                bindVar = (String)marker.getAttribute(SqlBindingMarkers.BIND_VARIABLE);
                icuName = icu.getElementName();
                Integer start = (Integer)marker.getAttribute("charStart");
                IJavaElement element = icu.getElementAt(start.intValue());
                if (TypeUtility.exists((IJavaElement)element) && element.getElementType() != 9) {
                    element = element.getAncestor(9);
                }
                if (TypeUtility.exists((IJavaElement)element) && element.getElementType() == 9) {
                    IgnoreSqlBindingAnnotationCreateOperation op = new IgnoreSqlBindingAnnotationCreateOperation((IMember)((IMethod)element), Signature.createTypeSignature((String)SqlBindingIgnoreValidation.class.getName(), (boolean)true), this.m_bindings);
                    OperationJob job = new OperationJob((IOperation)op);
                    job.schedule();
                    job.join();
                    JdtUiUtility.showJavaElementInEditor(element, false);
                }
            }
        }
        catch (Exception exception) {
            ScoutSdkUi.logError("could not applay annotation resolution for bindvar '" + bindVar + "' in  '" + icuName + "'.");
        }
    }

    public String[] getBindings() {
        return this.m_bindings;
    }
}

