/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.icons;

import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.IconProposal;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class IconTableContentProvider
extends ViewerComparator
implements IStructuredContentProvider,
ITableLabelProvider,
ITableColorProvider {
    private IconProposal[] m_icons;

    public IconTableContentProvider() {
        this(new IconProposal[0]);
    }

    public IconTableContentProvider(IconProposal[] icons) {
        this.setIcons(icons);
    }

    public void setIcons(IconProposal[] icons) {
        this.m_icons = icons;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_icons;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image img = null;
        if (columnIndex == 0) {
            img = ((IconProposal)element).getImage();
        }
        return img;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return ((IconProposal)element).getImageDescription().getId();
            }
            case 2: {
                return ((IconProposal)element).getImageDescription().getIconName();
            }
        }
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        Color c = null;
        if (element instanceof IconProposal && ((IconProposal)element).getImageDescription().isInherited()) {
            c = ScoutSdkUi.getColor("inactiveForeground");
        }
        return c;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        Table table = (Table)viewer.getControl();
        TableColumn sortCol = table.getSortColumn();
        boolean sortAsc = table.getSortDirection() == 128;
        int columnIndex = sortCol != null ? table.indexOf(sortCol) : 1;
        int c = super.compare(viewer, (Object)this.getColumnText(e1, columnIndex), (Object)this.getColumnText(e2, columnIndex));
        if (!sortAsc) {
            c = -c;
        }
        return c;
    }
}

