/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.icons;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.internal.view.icons.IconRowFilter;
import org.eclipse.scout.sdk.ui.internal.view.icons.IconTableContentProvider;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class IconsEditor
extends EditorPart {
    public static final String ID = IconsEditor.class.getName();
    private FormToolkit m_toolkit;
    private Form m_form;
    private Table m_table;
    private TableViewer m_viewer;
    private IconTableContentProvider m_contentProvider;
    private IconRowFilter m_inheritedFilter = new IconRowFilter();

    public void createPartControl(Composite parent) {
        this.m_toolkit = new FormToolkit(parent.getDisplay());
        this.m_form = this.m_toolkit.createForm(parent);
        this.m_form.setText("Icons");
        Composite body = this.m_form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.createFormBody(body);
    }

    private void createFormBody(Composite parent) {
        this.m_table = this.m_toolkit.createTable(parent, 65536);
        this.m_table.setLinesVisible(true);
        this.m_table.setHeaderVisible(true);
        TableColumn[] columns = new TableColumn[3];
        columns[0] = new TableColumn(this.m_table, 16384);
        columns[0].setWidth(20);
        columns[1] = new TableColumn(this.m_table, 16384);
        columns[1].setText("KEY");
        columns[1].setWidth(300);
        columns[2] = new TableColumn(this.m_table, 16384);
        columns[2].setText("Name");
        columns[2].setWidth(300);
        P_SortSelectionAdapter sortListener = new P_SortSelectionAdapter();
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn c = tableColumnArray[n2];
            c.addSelectionListener((SelectionListener)sortListener);
            ++n2;
        }
        this.m_viewer = new TableViewer(this.m_table);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)this.m_contentProvider);
        this.m_viewer.setContentProvider((IContentProvider)this.m_contentProvider);
        this.m_viewer.setComparator((ViewerComparator)this.m_contentProvider);
        this.m_viewer.setInput((Object)this.m_contentProvider);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_table.setLayoutData((Object)new GridData(1808));
    }

    public void setScoutSharedBundle(IScoutBundle sharedBundle) {
        if (sharedBundle != null) {
            this.m_contentProvider.setIcons(ScoutProposalUtility.getScoutIconProposals(ScoutSdkUi.getDisplay(), sharedBundle));
            this.m_inheritedFilter.setScoutBundle(sharedBundle);
            if (this.m_viewer != null && !this.m_viewer.getControl().isDisposed()) {
                this.m_viewer.refresh();
            }
        }
    }

    public void setHideInherited(boolean hideInherited) {
        this.m_table.setRedraw(false);
        try {
            if (hideInherited) {
                this.m_viewer.addFilter((ViewerFilter)this.m_inheritedFilter);
            } else {
                this.m_viewer.removeFilter((ViewerFilter)this.m_inheritedFilter);
            }
        }
        finally {
            this.m_table.setRedraw(true);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.m_contentProvider = new IconTableContentProvider();
        if (input instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            IScoutBundle scoutProject = ScoutSdk.getScoutWorkspace().getScoutBundle(file.getProject());
            if (scoutProject.getType() == 4) {
                this.setScoutSharedBundle(scoutProject);
            }
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void setFocus() {
        this.m_form.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private class P_SortSelectionAdapter
    extends SelectionAdapter {
        private P_SortSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.getSource();
            if (IconsEditor.this.m_table.getSortColumn() == col) {
                if (IconsEditor.this.m_table.getSortDirection() == 128) {
                    IconsEditor.this.m_table.setSortDirection(1024);
                } else {
                    IconsEditor.this.m_table.setSortDirection(128);
                }
            } else {
                IconsEditor.this.m_table.setSortColumn(col);
                IconsEditor.this.m_table.setSortDirection(128);
            }
            IconsEditor.this.m_viewer.refresh();
        }
    }
}

