/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.ui.actions.CollapseAllAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.LRUCache;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.LinkWithEditorAction;
import org.eclipse.scout.sdk.ui.action.ScoutProjectNewAction;
import org.eclipse.scout.sdk.ui.extensions.IScoutSdkExtension;
import org.eclipse.scout.sdk.ui.internal.extensions.ScoutExtensionsExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.view.outline.DirtyUpdateManager;
import org.eclipse.scout.sdk.ui.internal.view.outline.IContentProviderListener;
import org.eclipse.scout.sdk.ui.internal.view.outline.ViewContentProvider;
import org.eclipse.scout.sdk.ui.internal.view.outline.ViewLabelProvider;
import org.eclipse.scout.sdk.ui.internal.view.outline.clipboard.ExplorerCopyAndPasteSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.dnd.ExplorerDndSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.job.FilterOutlineJob;
import org.eclipse.scout.sdk.ui.internal.view.outline.job.LoadInitialOutlineProcess;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.InvisibleRootNodePage;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPageFilter;
import org.eclipse.scout.sdk.workspace.IScoutWorkspaceListener;
import org.eclipse.scout.sdk.workspace.ScoutWorkspaceEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ScoutExplorerPart
extends ViewPart
implements IScoutExplorerPart {
    public static final int IS_LINKING_ENABLED_PROPERTY = 1;
    private String LINKING_ENABLED = "OutlineView.LINKING_ENABLED";
    private TreeViewer m_viewer;
    private InvisibleRootNodePage m_invisibleRoot;
    private ViewContentProvider m_viewContentProvider;
    private DirtyUpdateManager m_dirtyManager;
    private Object m_pageFilterCacheLock = new Object();
    private LRUCache<String, IPageFilter> m_pageFilterCache = new LRUCache(10000, -1L);
    private ISelectionListener m_javaEditorSelectionListner;
    private P_OutlineSelectionProvider m_outlineSelectionProvider;
    private boolean m_linkingEnabled;
    private LinkWithEditorAction m_linkWithEditorAction;
    private P_ReloadNodeJob m_reloadJob = new P_ReloadNodeJob();

    public ScoutExplorerPart() {
        this.m_dirtyManager = new DirtyUpdateManager(this);
    }

    public TreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    public ViewContentProvider getViewContentProvider() {
        return this.m_viewContentProvider;
    }

    public void createPartControl(Composite parent) {
        Tree tree = new Tree(parent, 770);
        this.m_viewer = new TreeViewer(tree);
        this.m_viewer.addFilter((ViewerFilter)new P_PageFilter());
        this.m_outlineSelectionProvider = new P_OutlineSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_outlineSelectionProvider);
        this.m_viewer.setUseHashlookup(true);
        this.m_viewContentProvider = new ViewContentProvider();
        this.m_viewContentProvider.addContentProviderListener(new IContentProviderListener(){

            @Override
            public void handleChildrenLoaded(IPage page) {
                ScoutExplorerPart.this.m_viewer.refresh((Object)page);
            }
        });
        this.m_viewer.setContentProvider((IContentProvider)this.m_viewContentProvider);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(parent, this));
        this.m_viewer.setSorter(null);
        this.m_invisibleRoot = new InvisibleRootNodePage(null, this);
        this.m_viewContentProvider.setRoot(this.m_invisibleRoot);
        this.m_viewer.setInput((Object)this.m_viewContentProvider);
        this.hookDragAndDrop(this.m_viewer);
        this.hookContextMenu();
        this.hookSelectionAction();
        this.hookDoubleClickAction();
        this.hookKeyActions();
        this.createToolbar();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)tree, "org.eclipse.scout.sdk.doc.outline");
        ScoutSdk.getScoutWorkspace().addWorkspaceListener(new IScoutWorkspaceListener(){

            public void worspaceChanged(ScoutWorkspaceEvent event) {
                switch (event.getType()) {
                    case 10: {
                        new LoadInitialOutlineProcess(ScoutExplorerPart.this).schedule();
                    }
                }
            }
        });
        this.expandAndSelectProjectLevel();
    }

    @Override
    public void expandAndSelectProjectLevel() {
        try {
            this.m_viewContentProvider.setLoadSync(true);
            this.m_viewer.expandToLevel(4);
            IPage[] children = this.m_invisibleRoot.getChildArray();
            if (children != null && children.length > 0) {
                IPage p = children[0];
                StructuredSelection outlineSelection = new StructuredSelection((Object)p);
                this.m_viewer.setSelection((ISelection)outlineSelection);
            }
        }
        finally {
            this.m_viewContentProvider.setLoadSync(false);
        }
    }

    public InvisibleRootNodePage getInvisibleRoot() {
        return this.m_invisibleRoot;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            Integer linkingEnabledInteger = memento.getInteger(this.LINKING_ENABLED);
            boolean linkingEnabled = linkingEnabledInteger != null ? linkingEnabledInteger == 1 : false;
            this.setLinkingEnabled(linkingEnabled);
        }
    }

    public void saveState(IMemento aMemento) {
        aMemento.putInteger(this.LINKING_ENABLED, this.m_linkingEnabled ? 1 : 0);
        super.saveState(aMemento);
    }

    public void dispose() {
        if (this.m_linkWithEditorAction != null) {
            this.m_linkWithEditorAction.dispose();
        }
        super.dispose();
    }

    public void setLinkingEnabled(boolean linkingEnabled) {
        this.m_linkingEnabled = linkingEnabled;
        this.firePropertyChange(1);
    }

    public boolean isLinkingEnabled() {
        return this.m_linkingEnabled;
    }

    public void markStructureDirty(AbstractPage newPage) {
        this.m_dirtyManager.notifyStructureDirty(newPage);
    }

    public IPage[] fetchDirtyStructurePages() {
        return this.m_dirtyManager.fetchDirtyStructurePages();
    }

    public void markFilterChanged(AbstractPage page) {
        new FilterOutlineJob(this, page).schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPageFilter getPageFilter(IPage page) {
        String key = this.getPageNodePath(page);
        Object object = this.m_pageFilterCacheLock;
        synchronized (object) {
            return (IPageFilter)this.m_pageFilterCache.get((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPageFilter(IPage page, IPageFilter filter) {
        String key = this.getPageNodePath(page);
        Object object = this.m_pageFilterCacheLock;
        synchronized (object) {
            IPageFilter oldFilter = (IPageFilter)this.m_pageFilterCache.get((Object)key);
            if (!CompareUtility.equals((Object)oldFilter, (Object)filter)) {
                this.m_pageFilterCache.put((Object)key, (Object)filter);
            }
            this.m_reloadJob.reloadDelayed(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPageFilter(IPage page) {
        String key = this.getPageNodePath(page);
        Object object = this.m_pageFilterCacheLock;
        synchronized (object) {
            if (this.m_pageFilterCache.containsKey((Object)key)) {
                this.m_pageFilterCache.remove((Object)key);
                this.m_reloadJob.reloadDelayed(page);
            }
        }
    }

    String getPageNodePath(IPage page) {
        StringBuilder b = new StringBuilder();
        IPage tmp = page;
        while (tmp != null) {
            b.insert(0, "/" + tmp.getName());
            tmp = tmp.getParent();
        }
        return b.toString();
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.m_linkWithEditorAction = new LinkWithEditorAction(this);
        this.m_linkWithEditorAction.updateLinkingEnabled(this.isLinkingEnabled());
        mgr.add((IAction)this.m_linkWithEditorAction);
        mgr.add((IAction)new CollapseAllAction(this.getTreeViewer()));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ScoutExplorerPart.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.m_viewer.getControl());
        this.m_viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.m_viewer.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.m_viewer.getSelection();
            if (selection.size() > 0) {
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof AbstractPage) {
                    AbstractPage page = (AbstractPage)firstElement;
                    page.fillContextMenu(manager);
                    IScoutSdkExtension[] iScoutSdkExtensionArray = ScoutExtensionsExtensionPoint.getExtensions();
                    int n = iScoutSdkExtensionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IScoutSdkExtension ext = iScoutSdkExtensionArray[n2];
                        ext.contributePageMenus(manager, page);
                        ++n2;
                    }
                }
            } else {
                manager.add((IAction)new ScoutProjectNewAction(this.getViewSite().getShell()));
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookSelectionAction() {
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ScoutExplorerPart.this.handleNodeSelection((StructuredSelection)e.getSelection());
            }
        });
    }

    private void hookDragAndDrop(TreeViewer viewer) {
        new ExplorerDndSupport(viewer);
    }

    private void hookKeyActions() {
        this.m_viewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(final KeyEvent e) {
                Object elem;
                List list;
                ISelection sel = ScoutExplorerPart.this.m_viewer.getSelection();
                if (sel instanceof StructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (elem = list.get(0)) instanceof AbstractPage) {
                    final AbstractPage page = (AbstractPage)elem;
                    ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (e.keyCode == 0x100000E) {
                                page.refresh(e.stateMask == 131072);
                            } else if (e.keyCode == 118 && e.stateMask == 262144) {
                                ExplorerCopyAndPasteSupport.performPaste(ScoutExplorerPart.this.m_viewer, page);
                            } else if (e.keyCode == 99 && e.stateMask == 262144) {
                                ExplorerCopyAndPasteSupport.performCopy(ScoutExplorerPart.this.m_viewer, page);
                            }
                        }
                    });
                }
            }
        });
    }

    private void hookDoubleClickAction() {
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ScoutExplorerPart.this.handleNodeAction((IStructuredSelection)((StructuredSelection)e.getSelection()));
            }
        });
    }

    private void handleNodeSelection(StructuredSelection selection) {
        for (Object o : selection) {
            if (!(o instanceof AbstractPage)) continue;
            ((AbstractPage)o).handleSelectionDelegate();
        }
    }

    private void handleNodeAction(IStructuredSelection selection) {
        Object firstElement;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof AbstractPage && !((AbstractPage)firstElement).handleDoubleClickedDelegate()) {
            this.m_viewer.setExpandedState(firstElement, !this.m_viewer.getExpandedState(firstElement));
        }
    }

    @Override
    public void setSelection(IStructuredSelection selection) {
        this.getTreeViewer().setSelection((ISelection)selection);
    }

    @Override
    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getTreeViewer().getSelection();
    }

    public void setFocus() {
        this.m_viewer.getControl().setFocus();
    }

    private class P_OutlineSelectionProvider
    implements ISelectionProvider,
    ISelectionChangedListener {
        private List<ISelectionChangedListener> m_selectionListeners;
        private OptimisticLock m_selectionLock = new OptimisticLock();

        public P_OutlineSelectionProvider() {
            this.m_selectionListeners = Collections.synchronizedList(new ArrayList());
            ScoutExplorerPart.this.m_viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.m_selectionListeners.add(listener);
        }

        public ISelection getSelection() {
            return ScoutExplorerPart.this.m_viewer.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.m_selectionListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            if (CompareUtility.notEquals((Object)ScoutExplorerPart.this.getTreeViewer().getSelection(), (Object)selection)) {
                try {
                    if (this.m_selectionLock.acquire()) {
                        ScoutExplorerPart.this.m_viewer.setSelection(selection, true);
                        this.setSelectionWithoutLock(selection);
                    }
                }
                finally {
                    this.m_selectionLock.release();
                }
            }
        }

        private void setSelectionWithoutLock(ISelection selection) {
            ISelectionChangedListener[] iSelectionChangedListenerArray = this.m_selectionListeners.toArray(new ISelectionChangedListener[this.m_selectionListeners.size()]);
            int n = iSelectionChangedListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionChangedListener l = iSelectionChangedListenerArray[n2];
                l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                ++n2;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (ScoutExplorerPart.this.m_viewer.getData("selectionPreventer") != null) {
                return;
            }
            try {
                if (this.m_selectionLock.acquire()) {
                    this.setSelectionWithoutLock(event.getSelection());
                }
            }
            finally {
                this.m_selectionLock.release();
            }
        }
    }

    private class P_PageFilter
    extends ViewerFilter {
        private P_PageFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            if (parent instanceof IPage) {
                IPage parentPage = (IPage)parent;
                IPageFilter filter = null;
                Object object = ScoutExplorerPart.this.m_pageFilterCacheLock;
                synchronized (object) {
                    filter = (IPageFilter)ScoutExplorerPart.this.m_pageFilterCache.get((Object)ScoutExplorerPart.this.getPageNodePath(parentPage));
                }
                if (filter != null) {
                    int size = elements.length;
                    ArrayList<IPage> out = new ArrayList<IPage>(size);
                    int i = 0;
                    while (i < size) {
                        IPage element = (IPage)elements[i];
                        if (filter.accept(element)) {
                            out.add(element);
                        }
                        ++i;
                    }
                    return out.toArray(new IPage[out.size()]);
                }
            }
            return elements;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return false;
        }
    }

    private class P_ReloadNodeJob
    extends Job {
        private Object lock;
        private IPage m_page;

        public P_ReloadNodeJob() {
            super("reload node");
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reloadDelayed(IPage page) {
            Object object = this.lock;
            synchronized (object) {
                this.cancel();
                this.m_page = page;
                this.schedule(300L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object object = this.lock;
            synchronized (object) {
                ScoutExplorerPart.this.getTreeViewer().getTree().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P_ReloadNodeJob.this.m_page != null) {
                            ScoutExplorerPart.this.getTreeViewer().refresh((Object)P_ReloadNodeJob.this.m_page);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

