/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.clipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Reader;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.NumberUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.extensions.IPasteTargetDelegator;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.TableFieldNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.PageWithTableNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.ColumnTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.TableNodePage;
import org.eclipse.scout.sdk.ui.view.outline.OutlinePasteTargetEvent;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.swt.widgets.MessageBox;

public class TableColumnWidthsPasteTargetDelegator
implements IPasteTargetDelegator {
    private static final String COLUMN_WIDTH_METHOD_NAME = "getConfiguredWidth";

    @Override
    public boolean performPaste(OutlinePasteTargetEvent event) {
        String content = this.getStringFromTransferable(event.getTransferData());
        if (content != null) {
            IType tableType;
            if (!this.fastDetection(content)) {
                return false;
            }
            HashMap<String, Integer> map = this.parseContent(content, event.getPage());
            if (map != null && (tableType = this.determineTableType(event.getPage(), map.keySet())) != null) {
                this.changeColumnWidths(tableType, map);
            }
        }
        return false;
    }

    private void showInfoMessageBox(AbstractPage page, String message) {
        MessageBox msgBox = new MessageBox(page.getOutlineView().getSite().getShell(), 34);
        msgBox.setMessage(message);
        msgBox.open();
    }

    private boolean fastDetection(String content) {
        try {
            String identifier = (String)ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.menus.CopyWidthsOfColumnsMenu").getField("COLUMN_COPY_CLIPBOARD_IDENTIFIER").getConstant();
            return content.startsWith(identifier);
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("Unable to get the identification constant from the scout class", e);
            return true;
        }
    }

    private String getStringFromTransferable(Transferable contents) {
        if (contents == null) {
            return null;
        }
        try {
            Reader reader = DataFlavor.stringFlavor.getReaderForText(contents);
            String content = IOUtility.getContent((Reader)reader);
            return content;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, Integer> parseContent(String content, AbstractPage page) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            content = content.replaceAll("\r", "");
            String[] lines = content.split("\n");
            int i = 1;
            while (true) {
                if (i >= lines.length) {
                    return map;
                }
                String line = lines[i];
                if (StringUtility.hasText((String)line)) {
                    String[] parts = line.split("\t");
                    Integer columnWidth = NumberUtility.nvl((Integer)new Integer(parts[1]), (Number)0);
                    if (columnWidth < 0) {
                        this.showInfoMessageBox(page, Texts.get((String)"ColumnWidthPasteInvalidWidth", (String[])new String[]{columnWidth.toString()}));
                        return null;
                    }
                    map.put(parts[0], columnWidth);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private IType determineTableType(AbstractPage page, Set<String> classNames) {
        IType[] tables;
        IType tableType = null;
        if (page instanceof ColumnTablePage) {
            tableType = ((ColumnTablePage)page).getColumnDeclaringType();
        } else if (page instanceof PageWithTableNodePage) {
            tables = SdkTypeUtility.getTables((IType)((PageWithTableNodePage)page).getType());
            if (tables.length > 0) {
                tableType = tables[0];
            } else {
                ScoutSdkUi.logInfo(Texts.get((String)"ColumnWidthPasteNoTableInPage"));
                this.showInfoMessageBox(page, Texts.get((String)"ColumnWidthPasteNoTableInPage"));
            }
        } else if (page instanceof TableFieldNodePage) {
            tables = SdkTypeUtility.getTables((IType)((TableFieldNodePage)page).getType());
            if (tables.length > 0) {
                tableType = tables[0];
            } else {
                ScoutSdkUi.logInfo(Texts.get((String)"ColumnWidthPasteNoTableInField"));
                this.showInfoMessageBox(page, Texts.get((String)"ColumnWidthPasteNoTableInField"));
            }
        } else if (page instanceof TableNodePage) {
            tableType = ((TableNodePage)page).getType();
        } else {
            ScoutSdkUi.logInfo(Texts.get((String)"ColumnWidthPasteUnsupportedSelection"));
            this.showInfoMessageBox(page, Texts.get((String)"ColumnWidthPasteUnsupportedSelection"));
        }
        if (tableType != null) {
            String tableTypeClassName = tableType.getFullyQualifiedName();
            for (String clazz : classNames) {
                if (clazz.startsWith(tableTypeClassName)) continue;
                ScoutSdkUi.logInfo(Texts.get((String)"ColumnWidthPasteDifferentTable", (String[])new String[]{tableTypeClassName, clazz}));
                this.showInfoMessageBox(page, Texts.get((String)"ColumnWidthPasteDifferentTable", (String[])new String[]{tableTypeClassName, clazz}));
                tableType = null;
                break;
            }
        }
        return tableType;
    }

    private void changeColumnWidths(IType tableType, HashMap<String, Integer> map) {
        IType[] iTypeArray = SdkTypeUtility.getColumns((IType)tableType);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType innerType = iTypeArray[n2];
            String className = innerType.getFullyQualifiedName();
            Integer columnWidth = map.get(className);
            if (columnWidth != null) {
                ConfigPropertyMethodUpdateOperation op = new ConfigPropertyMethodUpdateOperation(innerType, COLUMN_WIDTH_METHOD_NAME, "  return " + columnWidth.toString() + ";", true);
                new OperationJob((IOperation)op).schedule();
            }
            ++n2;
        }
    }
}

