/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.dnd;

import org.eclipse.jdt.core.IType;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.action.dnd.FormFieldRelocateAction;
import org.eclipse.scout.sdk.ui.extensions.IDropTargetDelegator;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.AbstractBoxNodePage;
import org.eclipse.scout.sdk.ui.view.outline.OutlineDropTargetEvent;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.client.ui.form.field.AbstractFormFieldNodePage;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;

public class FormFieldDropTargetDelegator
implements IDropTargetDelegator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateDrop(OutlineDropTargetEvent event) {
        try {
            if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.getTransferData())) {
                return false;
            }
            Object currentTargetPage = event.getCurrentTarget();
            IType targetType = null;
            if (currentTargetPage instanceof AbstractBoxNodePage) {
                targetType = ((AbstractBoxNodePage)currentTargetPage).getType();
                if (event.getCurrentLocation() != 3 && targetType.getElementName().equals("MainBox")) {
                    return false;
                }
            } else if (currentTargetPage instanceof AbstractFormFieldNodePage) {
                if (event.getCurrentLocation() == 3) {
                    return false;
                }
                targetType = ((AbstractFormFieldNodePage)currentTargetPage).getType();
            }
            if (targetType == null) {
                return false;
            }
            IType selectedType = null;
            if (event.getSelectedObject() instanceof AbstractBoxNodePage) {
                selectedType = ((AbstractBoxNodePage)event.getSelectedObject()).getType();
            } else if (event.getSelectedObject() instanceof AbstractFormFieldNodePage) {
                selectedType = ((AbstractFormFieldNodePage)event.getSelectedObject()).getType();
            }
            if (selectedType == null || targetType.equals(selectedType)) {
                return false;
            }
            if (event.getOperation() == 1 && selectedType.getCompilationUnit().equals(targetType.getCompilationUnit()) && SdkTypeUtility.getFormFields((IType)selectedType).length > 0) {
                return false;
            }
            return !selectedType.equals(targetType);
        }
        catch (Exception e) {
            ScoutSdk.logWarning((String)"could not validate drop location.", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean expand(OutlineDropTargetEvent event) {
        return !(event.getCurrentTarget() instanceof AbstractFormFieldNodePage);
    }

    @Override
    public boolean performDrop(OutlineDropTargetEvent event) {
        if (event.getOperation() == 1 || event.getOperation() == 2) {
            AbstractScoutTypePage sourcePage = (AbstractScoutTypePage)event.getSelectedObject();
            AbstractScoutTypePage targetPage = (AbstractScoutTypePage)event.getCurrentTarget();
            FormFieldRelocateAction action = new FormFieldRelocateAction(sourcePage.getType(), sourcePage.getOutlineView().getSite().getShell());
            action.setCreateCopy(event.getOperation() == 1);
            action.setLocation(this.dndToMoveOperationLocation(event.getCurrentLocation()));
            if (event.getCurrentLocation() == 3) {
                action.setTargetDeclaringType(targetPage.getType());
            } else {
                action.setTargetDeclaringType(targetPage.getType().getDeclaringType());
                action.setNeighborField(targetPage.getType());
            }
            action.run();
        }
        return true;
    }

    private int dndToMoveOperationLocation(int location) {
        switch (location) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 3;
    }
}

