/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.dnd;

import org.eclipse.jdt.core.IType;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.action.dnd.TableColumnRelocateAction;
import org.eclipse.scout.sdk.ui.extensions.IDropTargetDelegator;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.ColumnNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.ColumnTablePage;
import org.eclipse.scout.sdk.ui.view.outline.OutlineDropTargetEvent;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.client.ui.form.field.AbstractFormFieldNodePage;

public class TableColumnDropTargetDelegator
implements IDropTargetDelegator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateDrop(OutlineDropTargetEvent event) {
        try {
            if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.getTransferData())) {
                return false;
            }
            Object currentTargetPage = event.getCurrentTarget();
            IType targetType = null;
            if (currentTargetPage instanceof ColumnTablePage) {
                if (event.getCurrentLocation() != 3) {
                    return false;
                }
                targetType = ((ColumnTablePage)currentTargetPage).getColumnDeclaringType();
            } else if (currentTargetPage instanceof ColumnNodePage) {
                if (event.getCurrentLocation() == 3) {
                    return false;
                }
                targetType = ((ColumnNodePage)currentTargetPage).getType();
            }
            if (targetType == null) {
                return false;
            }
            IType selectedType = null;
            if (event.getSelectedObject() instanceof ColumnNodePage) {
                selectedType = ((ColumnNodePage)event.getSelectedObject()).getType();
            }
            if (selectedType == null) {
                return false;
            }
            return !selectedType.equals(targetType);
        }
        catch (Exception e) {
            ScoutSdk.logWarning((String)"could not validate drop location.", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean expand(OutlineDropTargetEvent event) {
        return !(event.getCurrentTarget() instanceof AbstractFormFieldNodePage);
    }

    @Override
    public boolean performDrop(OutlineDropTargetEvent event) {
        if (event.getOperation() == 1 || event.getOperation() == 2) {
            IType targetDeclaringType = null;
            IType targetNeighborType = null;
            if (event.getCurrentTarget() instanceof ColumnNodePage) {
                targetNeighborType = ((ColumnNodePage)event.getCurrentTarget()).getType();
                targetDeclaringType = targetNeighborType.getDeclaringType();
            } else if (event.getCurrentTarget() instanceof ColumnTablePage) {
                targetDeclaringType = ((ColumnTablePage)event.getCurrentTarget()).getColumnDeclaringType();
            }
            AbstractScoutTypePage sourcePage = (AbstractScoutTypePage)event.getSelectedObject();
            TableColumnRelocateAction action = new TableColumnRelocateAction(sourcePage.getType(), sourcePage.getOutlineView().getSite().getShell());
            action.setCreateCopy(event.getOperation() == 1);
            action.setLocation(this.dndToMoveOperationLocation(event.getCurrentLocation()));
            action.setTargetDeclaringType(targetDeclaringType);
            action.setNeighborField(targetNeighborType);
            action.run();
        }
        return true;
    }

    private IType getDeclaringTableType(Object target) {
        if (target instanceof ColumnTablePage) {
            return ((ColumnTablePage)target).getColumnDeclaringType();
        }
        if (target instanceof ColumnNodePage) {
            return ((ColumnNodePage)target).getType().getDeclaringType();
        }
        return null;
    }

    private int dndToMoveOperationLocation(int location) {
        switch (location) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        return 3;
    }
}

