/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.job;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.scout.sdk.jobs.AbstractWorkspaceBlockingJob;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerPart;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.InvisibleRootNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class RefreshOutlineSubTreeOperation
extends AbstractWorkspaceBlockingJob {
    public static final String SELECTION_PREVENTER = "selectionPreventer";
    private ScoutExplorerPart m_view;
    private P_BackupNode[] m_backupTree;
    private String m_selectedNodeName;
    private ITreeSelection m_backupedSelection;

    public RefreshOutlineSubTreeOperation(ScoutExplorerPart view, String name) {
        super(name);
        this.m_view = view;
    }

    public void run(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        Cursor waitCursor;
        Control m_treeControl;
        TreeViewer m_treeViewer;
        Display display;
        IPage[] dirtyStructureRoots;
        block9: {
            block10: {
                dirtyStructureRoots = this.m_view.fetchDirtyStructurePages();
                if (dirtyStructureRoots.length == 0) {
                    return;
                }
                display = ScoutSdkUi.getDisplay();
                m_treeViewer = this.m_view.getTreeViewer();
                m_treeControl = m_treeViewer.getControl();
                waitCursor = new Cursor((Device)display, 1);
                this.m_backupTree = new P_BackupNode[dirtyStructureRoots.length];
                if (dirtyStructureRoots.length <= 0) break block9;
                if (m_treeControl != null && !m_treeControl.isDisposed()) break block10;
                if (m_treeControl == null || m_treeControl.isDisposed()) {
                    return;
                }
                display.syncExec(new Runnable(m_treeControl, dirtyStructureRoots, m_treeViewer){
                    private final /* synthetic */ Control val$m_treeControl;
                    private final /* synthetic */ IPage[] val$dirtyStructureRoots;
                    private final /* synthetic */ TreeViewer val$m_treeViewer;
                    {
                        this.val$m_treeControl = control;
                        this.val$dirtyStructureRoots = iPageArray;
                        this.val$m_treeViewer = treeViewer;
                    }

                    @Override
                    public void run() {
                        if (this.val$m_treeControl == null || this.val$m_treeControl.isDisposed()) {
                            return;
                        }
                        if (this.val$dirtyStructureRoots.length > 0) {
                            IPage[] iPageArray = this.val$dirtyStructureRoots;
                            int n = this.val$dirtyStructureRoots.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IPage p = iPageArray[n2];
                                this.val$m_treeViewer.refresh((Object)p, true);
                                ++n2;
                            }
                            int i = 0;
                            while (i < RefreshOutlineSubTreeOperation.this.m_backupTree.length) {
                                RefreshOutlineSubTreeOperation.this.m_backupTree[i].restoreGui(this.val$dirtyStructureRoots[i]);
                                ++i;
                            }
                            RefreshOutlineSubTreeOperation.this.restoreSelectionInUiThread();
                        }
                        RefreshOutlineSubTreeOperation.this.m_view.getViewContentProvider().setAutoLoadChildren(true);
                        this.val$m_treeControl.setCursor(null);
                    }
                });
                waitCursor.dispose();
                return;
            }
            try {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (m_treeControl == null || m_treeControl.isDisposed()) {
                            return;
                        }
                        m_treeControl.setCursor(waitCursor);
                        RefreshOutlineSubTreeOperation.this.m_view.getViewContentProvider().setAutoLoadChildren(false);
                        RefreshOutlineSubTreeOperation.this.m_backupedSelection = (ITreeSelection)m_treeViewer.getSelection();
                        IPage selectedPage = (IPage)((ITreeSelection)m_treeViewer.getSelection()).getFirstElement();
                        RefreshOutlineSubTreeOperation.this.m_selectedNodeName = selectedPage != null ? selectedPage.getName() : null;
                        int i = 0;
                        while (i < RefreshOutlineSubTreeOperation.this.m_backupTree.length) {
                            ((RefreshOutlineSubTreeOperation)RefreshOutlineSubTreeOperation.this).m_backupTree[i] = new P_BackupNode(null, dirtyStructureRoots[i]);
                            ++i;
                        }
                    }
                });
                int i = 0;
                while (i < this.m_backupTree.length) {
                    if (this.m_backupTree[i] != null) {
                        this.m_backupTree[i].refreshStructure(dirtyStructureRoots[i]);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                if (m_treeControl == null || m_treeControl.isDisposed()) {
                    return;
                }
                display.syncExec(new /* invalid duplicate definition of identical inner class */);
                waitCursor.dispose();
                throw throwable;
            }
        }
        if (m_treeControl == null || m_treeControl.isDisposed()) {
            return;
        }
        display.syncExec(new /* invalid duplicate definition of identical inner class */);
        waitCursor.dispose();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void restoreSelectionInUiThread() {
        boolean isNewSelection = false;
        TreePath[] paths = this.m_backupedSelection.getPaths();
        ArrayList<TreePath> newPaths = new ArrayList<TreePath>();
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath p = treePathArray[n2];
            ArrayList<Object> newSegments = new ArrayList<Object>();
            int i = 0;
            while (i < p.getSegmentCount()) {
                block6: {
                    Object segment = p.getSegment(i);
                    if (segment instanceof ITypePage) {
                        if (((ITypePage)segment).getType().exists()) {
                            newSegments.add(segment);
                            break block6;
                        } else {
                            isNewSelection = true;
                            break;
                        }
                    }
                    newSegments.add(segment);
                }
                ++i;
            }
            newPaths.add(new TreePath(newSegments.toArray()));
            ++n2;
        }
        if (isNewSelection) {
            this.m_view.getTreeViewer().setSelection((ISelection)new TreeSelection(newPaths.toArray(new TreePath[newPaths.size()])));
        }
    }

    private class P_BackupNode {
        private String m_name;
        private boolean m_expanded;
        private HashMap<String, P_BackupNode> m_children = new HashMap();

        public P_BackupNode(P_BackupNode parent, IPage p) {
            this.m_name = p.getName();
            this.m_expanded = RefreshOutlineSubTreeOperation.this.m_view.getTreeViewer().getExpandedState((Object)p);
            if (parent != null) {
                parent.m_children.put(this.m_name, this);
            }
            if (this.m_expanded) {
                for (IPage childPage : p.getChildren()) {
                    new P_BackupNode(this, childPage);
                }
            }
        }

        public void refreshStructure(IPage p) {
            if (p.getParent() != null || p instanceof InvisibleRootNodePage) {
                p.unloadChildren();
                if (this.m_expanded) {
                    p.loadChildren();
                    for (IPage childPage : p.getChildren()) {
                        P_BackupNode node = this.m_children.get(childPage.getName());
                        if (node == null) continue;
                        node.refreshStructure(childPage);
                    }
                }
            }
        }

        public void restoreGui(IPage p) {
            if (this.m_expanded) {
                RefreshOutlineSubTreeOperation.this.m_view.getTreeViewer().setExpandedState((Object)p, true);
                for (IPage childPage : p.getChildren()) {
                    P_BackupNode node = this.m_children.get(childPage.getName());
                    if (node == null) continue;
                    node.restoreGui(childPage);
                }
            }
        }
    }
}

