/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.NamingUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.InvisibleRootNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.UiSwingNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.UiSwtNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientLookupCallTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientServiceNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientSessionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.DesktopNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.DesktopOutlineTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.KeyStrokeNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.KeyStrokeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.MenuNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.MenuTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ToolButtonTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormHandlerNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormHandlerTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.SearchFormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.AbstractBoxNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.composer.attribute.AttributeNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.composer.attribute.AttributeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.composer.entity.EntityNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field.composer.entity.EntityTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.AllPagesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.PageWithNodeNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.PageWithTableNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.childpage.NodePageChildPageTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.ColumnNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.ColumnTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.table.TableNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardStepNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardStepTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerSessionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.CommonServicesNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.bookmark.BookmarkStorageServiceNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.bookmark.BookmarkStorageServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.calendar.CalendarServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.sql.SqlServiceNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.sql.SqlServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom.CustomServiceNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom.CustomServicePackageNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom.CustomServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup.LookupServiceNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup.LookupServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.outline.OutlineServiceNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.outline.OutlineServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.process.ProcessServiceNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.process.ProcessServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeTypeNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeTypeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.IconNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.LookupCallTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.NlsTextsNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.PermissionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.PermissionTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedContextPropertyNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedContextPropertyTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.INodeVisitor;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty.BeanPropertyNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.basic.beanproperty.BeanPropertyTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.IProjectNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.client.ui.form.field.AbstractFormFieldNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.server.service.AbstractServiceNodePage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.member.IPropertyBean;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;

public class EditorSelectionVisitor
implements INodeVisitor {
    public IPage m_nodeToSelect;
    private Iterator<IJavaElement> m_elementIterator;
    private IJavaElement m_currentElement;
    private HashMap<IJavaElement, ITypeHierarchy> m_typeHierarchyCache = new HashMap();
    private HashSet<IPage> m_visitedNodes = new HashSet();
    private ArrayList<IJavaElement> m_elements;

    public EditorSelectionVisitor(IJavaElement element) {
        IMethod declaringMethod = null;
        declaringMethod = element.getElementType() == 9 ? (IMethod)element : (IMethod)element.getAncestor(9);
        ArrayList<IJavaElement> collector = new ArrayList<IJavaElement>();
        IType declaringType = null;
        if (declaringMethod != null) {
            collector.add((IJavaElement)declaringMethod);
            declaringType = declaringMethod.getDeclaringType();
        } else {
            declaringType = element.getElementType() == 7 ? (IType)element : (IType)element.getAncestor(7);
        }
        if (declaringType != null) {
            this.recCollectDeclaringTypes(declaringType, collector);
            this.m_elements = collector;
            this.m_elementIterator = collector.iterator();
            this.m_currentElement = this.m_elementIterator.next();
        }
    }

    public IPage findPageToSelect(IPage startPage) {
        IPage visitPage = startPage;
        Object currElement = this.m_currentElement;
        while (visitPage != null) {
            if (visitPage instanceof ITypePage) {
                ITypePage tp = (ITypePage)visitPage;
                while (currElement != null) {
                    if (CompareUtility.equals((Object)currElement, (Object)tp.getType())) {
                        this.m_currentElement = currElement;
                        break;
                    }
                    currElement = this.m_elementIterator.hasNext() ? this.m_elementIterator.next() : null;
                }
            } else {
                currElement = null;
            }
            if (currElement != null) {
                startPage = visitPage;
                break;
            }
            this.m_elementIterator = this.m_elements.iterator();
            currElement = this.m_elementIterator.next();
            visitPage = visitPage.getParent();
        }
        if (this.m_currentElement == null) {
            this.m_elementIterator = this.m_elements.iterator();
            this.m_currentElement = this.m_elementIterator.next();
        }
        if (this.m_currentElement != null) {
            IPage page = this.findPageToSelectRec(startPage);
            return page;
        }
        return null;
    }

    private IPage findPageToSelectRec(IPage startPage) {
        if (startPage != null) {
            startPage.accept(this);
            if (this.m_nodeToSelect != null) {
                return this.m_nodeToSelect;
            }
            return this.findPageToSelectRec(startPage.getParent());
        }
        return this.m_nodeToSelect;
    }

    private void recCollectDeclaringTypes(IType type, ArrayList<IJavaElement> collector) {
        if (TypeUtility.exists((IJavaElement)type)) {
            collector.add(0, (IJavaElement)type);
            this.recCollectDeclaringTypes(type.getDeclaringType(), collector);
        }
    }

    public IPage getNodeToSelect() {
        return this.m_nodeToSelect;
    }

    private ITypeHierarchy getCachedTypeHierarchy(IJavaElement element) {
        ITypeHierarchy hierarchy = this.m_typeHierarchyCache.get(element);
        if (hierarchy == null && element.getElementType() == 7) {
            IType type = (IType)element;
            try {
                hierarchy = type.newSupertypeHierarchy(null);
                this.m_typeHierarchyCache.put(element, hierarchy);
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logError("could not build supertype hierarchy of '" + type.getFullyQualifiedName() + "'.", e);
            }
        }
        return hierarchy;
    }

    @Override
    public int visit(IPage page) {
        if (this.m_visitedNodes.contains(page)) {
            return 3;
        }
        this.m_visitedNodes.add(page);
        if (page instanceof InvisibleRootNodePage) {
            return 1;
        }
        if (page instanceof UiSwingNodePage) {
            return this.visitBundleNodePage(((UiSwingNodePage)page).getScoutResource());
        }
        if (page instanceof UiSwtNodePage) {
            return this.visitBundleNodePage(((UiSwtNodePage)page).getScoutResource());
        }
        if (page instanceof IProjectNodePage) {
            return this.visitProjectNode((IProjectNodePage)page);
        }
        if (page instanceof IconNodePage) {
            return 3;
        }
        if (page instanceof NlsTextsNodePage) {
            return 3;
        }
        if (page instanceof ClientNodePage) {
            return this.visitBundleNodePage(((ClientNodePage)page).getScoutResource());
        }
        if (page instanceof SharedNodePage) {
            return this.visitBundleNodePage(((SharedNodePage)page).getScoutResource());
        }
        if (page instanceof ServerNodePage) {
            return this.visitBundleNodePage(((ServerNodePage)page).getScoutResource());
        }
        if (page instanceof ClientSessionNodePage) {
            return this.visitPageWithType((AbstractScoutTypePage)page);
        }
        if (page instanceof DesktopNodePage) {
            return this.visitPageWithType((AbstractScoutTypePage)page);
        }
        if (page instanceof MenuTablePage) {
            return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu"));
        }
        if (page instanceof MenuNodePage) {
            return this.visitPageWithType((AbstractScoutTypePage)page);
        }
        if (page instanceof ToolButtonTablePage) {
            return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.tool.IToolButton"));
        }
        if (page instanceof DesktopOutlineTablePage) {
            return this.visitDesktopOutlineTablePage((DesktopOutlineTablePage)page);
        }
        if (page instanceof SearchFormTablePage) {
            return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm"));
        }
        if (page instanceof FormTablePage) {
            return this.visitFormTablePage((FormTablePage)page);
        }
        if (page instanceof FormNodePage) {
            return this.visitPageWithType((AbstractScoutTypePage)page);
        }
        if (page instanceof BeanPropertyTablePage) {
            return this.visitBeanPropertyTablePage((BeanPropertyTablePage)page);
        }
        if (!(page instanceof BeanPropertyNodePage)) {
            if (page instanceof AbstractBoxNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof KeyStrokeTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke"));
            }
            if (page instanceof KeyStrokeNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof AttributeTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.IComposerAttribute"));
            }
            if (page instanceof AttributeNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof EntityTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.composer.entity.IComposerEntity"));
            }
            if (page instanceof EntityNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof AbstractFormFieldNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof FormHandlerTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IFormHandler"));
            }
            if (page instanceof FormHandlerNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof SearchFormTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm"));
            }
            if (page instanceof WizardTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizard"));
            }
            if (page instanceof WizardNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof WizardStepTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizardStep"));
            }
            if (page instanceof WizardStepNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof ClientLookupCallTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall"));
            }
            if (page instanceof ClientServiceTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.service.IService"));
            }
            if (page instanceof ClientServiceNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof OutlineTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline"));
            }
            if (page instanceof OutlineNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof AllPagesTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage"));
            }
            if (page instanceof NodePageChildPageTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage"));
            }
            if (page instanceof PageWithNodeNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof PageWithTableNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof TableNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof ColumnTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn"));
            }
            if (page instanceof ColumnNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof SharedContextPropertyTablePage) {
                return this.visitShareContextPropertyTablePage((SharedContextPropertyTablePage)page);
            }
            if (page instanceof SharedContextPropertyNodePage) {
                return this.visitSharedContextPropertyNodePage((SharedContextPropertyNodePage)page);
            }
            if (page instanceof PermissionTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"java.security.BasicPermission"));
            }
            if (page instanceof PermissionNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof CodeTypeTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType"));
            }
            if (page instanceof CodeTypeNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof CodeNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof ServerSessionNodePage) {
                return this.visitPageWithType((AbstractScoutTypePage)page);
            }
            if (page instanceof LookupServiceTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService"));
            }
            if (page instanceof LookupServiceNodePage) {
                return this.visitServiceNodePage((LookupServiceNodePage)page);
            }
            if (page instanceof LookupCallTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.lookup.LookupCall"));
            }
            if (page instanceof OutlineServiceTablePage) {
                return this.visitOutlineServiceTablePage((OutlineServiceTablePage)page);
            }
            if (page instanceof OutlineServiceNodePage) {
                return this.visitServiceNodePage((OutlineServiceNodePage)page);
            }
            if (page instanceof ProcessServiceTablePage) {
                return this.visitProcessServiceTablePage((ProcessServiceTablePage)page);
            }
            if (page instanceof ProcessServiceNodePage) {
                return this.visitServiceNodePage((ProcessServiceNodePage)page);
            }
            if (page instanceof CommonServicesNodePage) {
                return this.visitServerServicesCommonNodePage((CommonServicesNodePage)page);
            }
            if (page instanceof SqlServiceTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.server.services.common.jdbc.ISqlService"));
            }
            if (page instanceof SqlServiceNodePage) {
                return this.visitServiceNodePage((SqlServiceNodePage)page);
            }
            if (page instanceof BookmarkStorageServiceTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.common.bookmark.IBookmarkStorageService"));
            }
            if (page instanceof BookmarkStorageServiceNodePage) {
                return this.visitServiceNodePage((BookmarkStorageServiceNodePage)page);
            }
            if (page instanceof CalendarServiceTablePage) {
                return this.visitTypeInHierarchyPage(ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.common.calendar.ICalendarService"));
            }
            if (page instanceof CustomServiceTablePage) {
                return this.visitCustomServiceTablePage((CustomServiceTablePage)page);
            }
            if (page instanceof CustomServiceNodePage) {
                return this.visitServiceNodePage((CustomServiceNodePage)page);
            }
            if (page instanceof CustomServicePackageNodePage) {
                return this.visitCustomServicePackageNodePage((CustomServicePackageNodePage)page);
            }
        }
        ScoutSdkUi.logWarning("not visited node '" + page.getClass().getName() + "'.");
        return 0;
    }

    private int visitProjectNode(IProjectNodePage page) {
        if (page.getScoutResource().contains(this.m_currentElement)) {
            return 2;
        }
        return 3;
    }

    private int visitBundleNodePage(IScoutBundle bundle) {
        if (bundle.getProject().exists(this.m_currentElement.getResource().getProjectRelativePath())) {
            return 2;
        }
        return 3;
    }

    protected int visitTypeInHierarchyPage(IType superType) {
        ITypeHierarchy hierarchy = this.getCachedTypeHierarchy(this.m_currentElement);
        if (hierarchy != null && hierarchy.contains(superType)) {
            return 2;
        }
        return 3;
    }

    protected int visitPageWithType(AbstractScoutTypePage page) {
        if (CompareUtility.equals((Object)this.m_currentElement, (Object)page.getType())) {
            this.m_nodeToSelect = page;
            if (this.m_elementIterator.hasNext()) {
                this.m_currentElement = this.m_elementIterator.next();
                return 2;
            }
            return 0;
        }
        return 3;
    }

    private int visitDesktopOutlineTablePage(DesktopOutlineTablePage page) {
        ITypeHierarchy hierarchy = this.getCachedTypeHierarchy(this.m_currentElement);
        if (hierarchy.contains(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline"))) {
            IType[] allNewOccurences;
            IType desktopType = page.getDesktopType();
            IMethod outlineMethods = TypeUtility.getMethod((IType)desktopType, (String)"getConfiguredOutlines");
            IType[] iTypeArray = allNewOccurences = TypeUtility.getNewTypeOccurencesInMethod((IMethod)outlineMethods);
            int n = allNewOccurences.length;
            int n2 = 0;
            while (n2 < n) {
                IType typeOccurence = iTypeArray[n2];
                if (typeOccurence.equals(desktopType)) {
                    return 2;
                }
                ++n2;
            }
        }
        return 3;
    }

    private int visitFormTablePage(FormTablePage page) {
        ITypeHierarchy hierarchy = this.getCachedTypeHierarchy(this.m_currentElement);
        if (hierarchy != null && hierarchy.contains(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm")) && !hierarchy.contains(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm"))) {
            return 2;
        }
        return 3;
    }

    protected int visitBeanPropertyTablePage(BeanPropertyTablePage page) {
        IMethod method;
        if (this.m_currentElement.getElementType() == 9 && TypeUtility.exists((IJavaElement)(method = (IMethod)this.m_currentElement).getAnnotation(NamingUtility.getSimpleName((String)"org.eclipse.scout.commons.annotations.ConfigPropertyValue")))) {
            return 2;
        }
        return 3;
    }

    protected int visitBeanPropertyNodePage(BeanPropertyNodePage page) {
        IPropertyBean desc = page.getPropertyDescriptor();
        if (this.m_currentElement.equals(desc.getReadMethod()) || this.m_currentElement.equals(desc.getWriteMethod())) {
            this.m_nodeToSelect = page;
            if (this.m_elementIterator.hasNext()) {
                this.m_currentElement = this.m_elementIterator.next();
                return 2;
            }
            return 0;
        }
        return 3;
    }

    private boolean isType(IJavaElement element) {
        return element != null && element.getElementType() == 7;
    }

    protected int visitShareContextPropertyTablePage(SharedContextPropertyTablePage page) {
        if (this.m_currentElement != null && this.m_currentElement.getElementType() == 9) {
            return 1;
        }
        return 3;
    }

    protected int visitSharedContextPropertyNodePage(SharedContextPropertyNodePage page) {
        IPropertyBean serverBeanDesc;
        if (this.m_currentElement != null && this.m_currentElement.getElementType() == 9 && (this.m_currentElement.equals((serverBeanDesc = page.getServerDesc()).getReadMethod()) || this.m_currentElement.equals(serverBeanDesc.getWriteMethod())) && this.m_elementIterator.hasNext()) {
            this.m_currentElement = this.m_elementIterator.next();
            this.m_nodeToSelect = page;
            return 2;
        }
        return 0;
    }

    protected int visitOutlineServiceTablePage(OutlineServiceTablePage page) {
        IType currentElement;
        ITypeHierarchy hierarchy;
        if (this.isType(this.m_currentElement) && (hierarchy = this.getCachedTypeHierarchy((IJavaElement)(currentElement = (IType)this.m_currentElement))) != null && hierarchy.contains(ScoutSdk.getType((String)"org.eclipse.scout.service.IService"))) {
            IScoutBundle serverBundle = page.getScoutResource();
            if (currentElement.getPackageFragment().getElementName().equals(serverBundle.getPackageName(".services.outline"))) {
                return 2;
            }
        }
        return 3;
    }

    protected int visitProcessServiceTablePage(ProcessServiceTablePage page) {
        IType currentElement;
        ITypeHierarchy hierarchy;
        if (this.isType(this.m_currentElement) && (hierarchy = this.getCachedTypeHierarchy((IJavaElement)(currentElement = (IType)this.m_currentElement))) != null && hierarchy.contains(ScoutSdk.getType((String)"org.eclipse.scout.service.IService"))) {
            IScoutBundle serverBundle = page.getScoutResource();
            if (currentElement.getPackageFragment().getElementName().equals(serverBundle.getPackageName(".services.process"))) {
                return 2;
            }
        }
        return 3;
    }

    protected int visitCustomServiceTablePage(CustomServiceTablePage page) {
        IType currentElement;
        ITypeHierarchy hierarchy;
        if (this.isType(this.m_currentElement) && (hierarchy = this.getCachedTypeHierarchy((IJavaElement)(currentElement = (IType)this.m_currentElement))) != null && hierarchy.contains(ScoutSdk.getType((String)"org.eclipse.scout.service.IService"))) {
            IScoutBundle serverBundle = page.getScoutResource();
            if (currentElement.getPackageFragment().getElementName().startsWith(serverBundle.getPackageName(".services.custom"))) {
                return 2;
            }
        }
        return 3;
    }

    protected int visitServiceNodePage(AbstractServiceNodePage page) {
        if (CompareUtility.equals((Object)this.m_currentElement, (Object)page.getInterfaceType()) || CompareUtility.equals((Object)this.m_currentElement, (Object)page.getType())) {
            if (this.m_elementIterator.hasNext()) {
                this.m_currentElement = this.m_elementIterator.next();
                return 2;
            }
            this.m_nodeToSelect = page;
            return 0;
        }
        return 3;
    }

    protected int visitServerServicesCommonNodePage(CommonServicesNodePage page) {
        IType currentElement;
        ITypeHierarchy hierarchy;
        if (this.isType(this.m_currentElement) && (hierarchy = this.getCachedTypeHierarchy((IJavaElement)(currentElement = (IType)this.m_currentElement))) != null && hierarchy.contains(ScoutSdk.getType((String)"org.eclipse.scout.service.IService"))) {
            IScoutBundle serverBundle = page.getScoutResource();
            if (currentElement.getPackageFragment().getElementName().startsWith(serverBundle.getPackageName(".services.common"))) {
                return 2;
            }
        }
        return 3;
    }

    protected int visitCustomServicePackageNodePage(CustomServicePackageNodePage page) {
        IType currentElement;
        ITypeHierarchy hierarchy;
        if (this.isType(this.m_currentElement) && (hierarchy = this.getCachedTypeHierarchy((IJavaElement)(currentElement = (IType)this.m_currentElement))) != null && hierarchy.contains(ScoutSdk.getType((String)"org.eclipse.scout.service.IService"))) {
            IScoutBundle serverBundle = page.getScoutResource();
            if (currentElement.getPackageFragment().getElementName().startsWith(serverBundle.getPackageName(".services.custom"))) {
                return 2;
            }
        }
        return 3;
    }

    private boolean isPropertyMethod(IJavaElement element) {
        IMethod method;
        return TypeUtility.exists((IJavaElement)element) && element.getElementType() == 9 && TypeUtility.hasAnnotation((IAnnotatable)(method = (IMethod)element), (String)"org.eclipse.scout.commons.annotations.FormData");
    }
}

