/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.ScoutProjectNewAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerPart;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ProjectNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.wizard.bundle.BundleImportWizard;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.IScoutWorkspaceListener;
import org.eclipse.scout.sdk.workspace.ScoutWorkspaceEvent;

public class InvisibleRootNodePage
extends AbstractPage {
    private ScoutExplorerPart m_view;
    private IScoutWorkspaceListener m_workspaceListener = new IScoutWorkspaceListener(){

        public void worspaceChanged(ScoutWorkspaceEvent event) {
            switch (event.getType()) {
                case 4: 
                case 5: 
                case 6: {
                    InvisibleRootNodePage.this.markStructureDirty();
                }
            }
        }
    };

    public InvisibleRootNodePage(IPage parent, ScoutExplorerPart view) {
        this.setParent(parent);
        this.setName("Scout Projects");
        this.m_view = view;
        ScoutSdk.getScoutWorkspace().addWorkspaceListener(this.m_workspaceListener);
    }

    @Override
    public void unloadPage() {
        ScoutSdk.getScoutWorkspace().removeWorkspaceListener(this.m_workspaceListener);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.InvisibleRootNodePage";
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public ScoutExplorerPart getOutlineView() {
        return this.m_view;
    }

    @Override
    public void loadChildrenImpl() {
        IScoutProject[] rootProjects = ScoutSdk.getScoutWorkspace().getRootProjects();
        ScoutSdkUi.logInfo("INVISIBLE ROOT NODE: found " + rootProjects.length + " root projects.");
        IScoutProject[] iScoutProjectArray = rootProjects;
        int n = rootProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutProject group = iScoutProjectArray[n2];
            new ProjectNodePage(this, group);
            ++n2;
        }
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IAction)new WizardAction("Import Plugin...", ScoutSdkUi.getImageDescriptor("add.png"), (IWizard)new BundleImportWizard()));
        manager.add((IAction)new ScoutProjectNewAction(this.getOutlineView().getViewSite().getShell()));
    }

    @Override
    public boolean isFolder() {
        return true;
    }
}

