/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.form.formdata.ScoutProjectUpdateFormDataOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformScoutProjectOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.OperationAction;
import org.eclipse.scout.sdk.ui.action.OrganizeAllImportsAction;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.UiSwingNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.UiSwtNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.project.IProjectNodePage;
import org.eclipse.scout.sdk.ui.wizard.bundle.BundleImportWizard;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.IScoutWorkspaceListener;
import org.eclipse.scout.sdk.workspace.ScoutWorkspaceEvent;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;

public class ProjectNodePage
extends AbstractPage
implements IProjectNodePage {
    private IScoutProject m_scoutProject;
    final IType iService = ScoutSdk.getType((String)"org.eclipse.scout.service.IService");
    private IScoutWorkspaceListener m_workspaceListener = new IScoutWorkspaceListener(){

        public void worspaceChanged(ScoutWorkspaceEvent event) {
            if (event.getType() == 4 && CompareUtility.equals((Object)event.getScoutElement(), (Object)ProjectNodePage.this.m_scoutProject)) {
                ProjectNodePage.this.markStructureDirty();
            }
        }
    };

    public ProjectNodePage(IPage parent, IScoutProject p) {
        this.setParent(parent);
        this.m_scoutProject = p;
        this.setName(p.getProjectName());
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("projectGroup.png"));
        ScoutSdk.getScoutWorkspace().addWorkspaceListener(this.m_workspaceListener);
    }

    @Override
    public void unloadPage() {
        ScoutSdk.getScoutWorkspace().removeWorkspaceListener(this.m_workspaceListener);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ProjectNodePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public IScoutProject getScoutResource() {
        return this.m_scoutProject;
    }

    @Override
    public void loadChildrenImpl() {
        try {
            if (this.getScoutResource().getUiSwingBundle() != null) {
                new UiSwingNodePage(this, this.getScoutResource().getUiSwingBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for UI swing bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        try {
            if (this.getScoutResource().getUiSwtBundle() != null) {
                new UiSwtNodePage(this, this.getScoutResource().getUiSwtBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for UI SWT bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        try {
            if (this.getScoutResource().getClientBundle() != null) {
                new ClientNodePage(this, this.getScoutResource().getClientBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for Client Bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        try {
            if (this.getScoutResource().getSharedBundle() != null) {
                new SharedNodePage(this, this.getScoutResource().getSharedBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for Shared Bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        try {
            if (this.getScoutResource().getServerBundle() != null) {
                new ServerNodePage(this, this.getScoutResource().getServerBundle());
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error during creating node page for Server Bundle in projct '" + this.getScoutResource().getProjectName() + "'.", e);
        }
        IScoutProject[] iScoutProjectArray = this.getScoutResource().getSubProjects();
        int n = iScoutProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutProject subProject = iScoutProjectArray[n2];
            try {
                new ProjectNodePage(this, subProject);
            }
            catch (Exception e) {
                ScoutSdkUi.logWarning("Error during creating node page for Project '" + subProject.getProjectName() + "'.", e);
            }
            ++n2;
        }
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IAction)new OrganizeAllImportsAction(this.getScoutResource()));
        manager.add((IAction)new WizardAction("Import Plugin...", ScoutSdkUi.getImageDescriptor("sharedBundle_add.png"), (IWizard)new BundleImportWizard(this.getScoutResource())));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform project...", (IOperation)new WellformScoutProjectOperation(this.getScoutResource())));
        manager.add((IAction)new OperationAction("Update form data...", ScoutSdkUi.getImageDescriptor("tool_loading.gif"), (IOperation)new ScoutProjectUpdateFormDataOperation(this.getScoutResource())));
        manager.add((IAction)new FormDataSqlBindingValidateAction(new ITypeResolver(){

            @Override
            public IType[] getTypes() {
                return ProjectNodePage.this.resolveServices();
            }
        }));
    }

    protected IType[] resolveServices() {
        IPrimaryTypeTypeHierarchy serviceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iService);
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassFilter(), TypeFilters.getTypesInScoutProject((IScoutProject)this.getScoutResource(), (boolean)true)});
        IType[] services = serviceHierarchy.getAllSubtypes(this.iService, filter);
        return services;
    }
}

