/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformLookupCallsOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.LookupCallNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.wizard.lookupcall.LocalLookupCallNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class ClientLookupCallTablePage
extends AbstractPage {
    final IType localLookupCall = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall");
    private ICachedTypeHierarchy m_lookupCallHierarchy;

    public ClientLookupCallTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"LocalLookupCallTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("lookupCalls.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_lookupCallHierarchy != null) {
            this.m_lookupCallHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_lookupCallHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_lookupCallHierarchy != null) {
            this.m_lookupCallHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ClientLookupCallTablePage";
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] lookupCalls;
        if (this.m_lookupCallHierarchy == null) {
            this.m_lookupCallHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.localLookupCall);
            this.m_lookupCallHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] iTypeArray = lookupCalls = this.m_lookupCallHierarchy.getAllClasses(TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), TypeComparators.getTypeNameComparator());
        int n = lookupCalls.length;
        int n2 = 0;
        while (n2 < n) {
            IType lookupcall = iTypeArray[n2];
            new LookupCallNodePage(this, lookupcall);
            ++n2;
        }
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform all lookup calls...", (IOperation)new WellformLookupCallsOperation(this.getScoutResource())));
    }

    @Override
    public Action createNewAction() {
        return new WizardAction("new Local LookupCall", ScoutSdkUi.getImageDescriptor("lookupCall_add.png"), (IWizard)new LocalLookupCallNewWizard(this.getScoutResource()));
    }
}

