/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.form.formdata.ClientBundleUpdateFormDataOperation;
import org.eclipse.scout.sdk.operation.template.InstallJavaFileOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformClientBundleOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.OperationAction;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientLookupCallTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.ClientSessionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.DesktopNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.TemplateTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.SearchFormTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.page.AllPagesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class ClientNodePage
extends AbstractPage {
    private ICachedTypeHierarchy m_clientSessionHierarchy;
    private ICachedTypeHierarchy m_desktopHierarchy;
    private final IScoutBundle m_clientProject;
    private IType iClientSession = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.IClientSession");
    private IType iDesktop = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.IDesktop");

    public ClientNodePage(AbstractPage parent, IScoutBundle clientProject) {
        this.setParent(parent);
        this.m_clientProject = clientProject;
        this.setName(this.getScoutResource().getSimpleName());
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("clientBundle.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_desktopHierarchy != null) {
            this.m_desktopHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_desktopHierarchy = null;
        }
        if (this.m_clientSessionHierarchy != null) {
            this.m_clientSessionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_clientSessionHierarchy = null;
        }
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ClientNodePage";
    }

    public IScoutBundle getScoutResource() {
        return this.m_clientProject;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] clientSessions;
        if (this.m_clientSessionHierarchy == null) {
            this.m_clientSessionHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iClientSession);
            this.m_clientSessionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        if (this.m_desktopHierarchy == null) {
            this.m_desktopHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iDesktop);
            this.m_desktopHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        if ((clientSessions = this.m_clientSessionHierarchy.getAllSubtypes(this.iClientSession, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()))).length > 1) {
            ScoutSdkUi.logWarning("more than one client session found.");
        } else if (clientSessions.length == 0) {
            ScoutSdkUi.logWarning("no client session found.");
        }
        IType[] iTypeArray = clientSessions;
        int n = clientSessions.length;
        int n2 = 0;
        while (n2 < n) {
            IType clientSession = iTypeArray[n2];
            new ClientSessionNodePage(this, clientSession);
            ++n2;
        }
        IType[] desktops = this.m_desktopHierarchy.getAllSubtypes(this.iDesktop, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()));
        if (desktops.length > 1) {
            ScoutSdkUi.logWarning("more than one desktop found.");
        } else if (desktops.length == 0) {
            ScoutSdkUi.logWarning(Texts.get((String)"NoDesktopFound"));
        }
        IType[] iTypeArray2 = desktops;
        int n3 = desktops.length;
        n = 0;
        while (n < n3) {
            IType desktop = iTypeArray2[n];
            new DesktopNodePage(this, desktop);
            ++n;
        }
        new FormTablePage(this);
        new SearchFormTablePage(this);
        new WizardTablePage(this);
        try {
            new ClientLookupCallTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("could not load LocalLookupCallTablePage.", e);
        }
        new ClientServiceTablePage(this);
        new OutlineTablePage(this);
        new AllPagesTablePage(this);
        new TemplateTablePage(this);
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        IType[] clientSessions;
        super.fillContextMenu(manager);
        if (this.m_clientSessionHierarchy != null && (clientSessions = this.m_clientSessionHierarchy.getAllClasses(TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), null)).length == 0) {
            manager.add((IAction)new OperationAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Client Session"}), ScoutSdkUi.getImageDescriptor("clientSession_add.png"), (IOperation)new InstallJavaFileOperation("templates/client/src/ClientSession.java", "ClientSession.java", this.getScoutResource())));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform client...", (IOperation)new WellformClientBundleOperation(this.getScoutResource())));
        manager.add((IAction)new OperationAction("Update form data...", ScoutSdkUi.getImageDescriptor("tool_loading.gif"), (IOperation)new ClientBundleUpdateFormDataOperation(this.getScoutResource())));
    }

    private IType resolveType(final String fqn) throws CoreException {
        final TreeMap matchList = new TreeMap();
        String fastPat = fqn;
        int i = fastPat.lastIndexOf(46);
        if (i >= 0) {
            fastPat = fastPat.substring(i + 1);
        }
        new SearchEngine().search(SearchPattern.createPattern((String)fastPat, (int)0, (int)0, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.getScoutResource().getSearchScope(), new SearchRequestor(){

            public final void acceptSearchMatch(SearchMatch match) throws CoreException {
                TypeDeclarationMatch typeMatch;
                IType t;
                if (match instanceof TypeDeclarationMatch && (t = (IType)(typeMatch = (TypeDeclarationMatch)match).getElement()).getFullyQualifiedName('.').indexOf(fqn) >= 0) {
                    matchList.put(new CompositeLong((long)(t.isBinary() ? 1 : 0), (long)matchList.size()), t);
                }
            }
        }, null);
        if (matchList.size() > 1) {
            ScoutSdk.logWarning((String)("found more than one type matches for '" + fqn + "' (matches: '" + matchList.size() + "')."));
        } else if (matchList.size() < 1) {
            ScoutSdk.logWarning((String)("found no type matches for '" + fqn + "'."));
            return null;
        }
        return (IType)matchList.firstEntry().getValue();
    }
}

