/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.KeyStrokeNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.ui.wizard.keystroke.KeyStrokeNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;

public class KeyStrokeTablePage
extends AbstractPage {
    final IType iKeyStrokeType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke");
    private final IType m_declaringType;
    private InnerTypePageDirtyListener m_keystrokeChangedListener;

    public KeyStrokeTablePage(IPage parentPage, IType declaringType) {
        this.m_declaringType = declaringType;
        this.setName(Texts.get((String)"KeyStrokesTablePage"));
        this.setParent(parentPage);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("keystrokes.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.KeyStrokeTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_keystrokeChangedListener != null) {
            ScoutSdk.removeInnerTypeChangedListener((IType)this.getDeclaringType(), (IJavaResourceChangedListener)this.m_keystrokeChangedListener);
            this.m_keystrokeChangedListener = null;
        }
    }

    @Override
    public void loadChildrenImpl() {
        if (this.m_keystrokeChangedListener == null) {
            this.m_keystrokeChangedListener = new InnerTypePageDirtyListener(this, this.iKeyStrokeType);
            ScoutSdk.addInnerTypeChangedListener((IType)this.getDeclaringType(), (IJavaResourceChangedListener)this.m_keystrokeChangedListener);
        }
        IType[] iTypeArray = SdkTypeUtility.getKeyStrokes((IType)this.getDeclaringType());
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType keyStroke = iTypeArray[n2];
            KeyStrokeNodePage childPage = new KeyStrokeNodePage();
            childPage.setParent(this);
            childPage.setType(keyStroke);
            ++n2;
        }
    }

    @Override
    public Action createNewAction() {
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Key stroke"}), ScoutSdkUi.getImageDescriptor("keystroke_add.png"), (IWizard)new KeyStrokeNewWizard(this.getDeclaringType()));
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }
}

