/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import java.util.Comparator;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.action.delete.MemberListDeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.TypeRenameAction;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.ui.wizard.menu.MenuNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;

public class MenuNodePage
extends AbstractScoutTypePage {
    static final IType iMenuType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu");
    private InnerTypePageDirtyListener m_menuChangedListener;

    public MenuNodePage(IPage parentPage, IType menuType) {
        this.setParent(parentPage);
        this.setType(menuType);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("menu.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.MenuNodePage";
    }

    @Override
    protected String getMethodNameForTranslatedText() {
        return "getConfiguredText";
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_menuChangedListener != null) {
            ScoutSdk.removeInnerTypeChangedListener((IType)this.getType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
            this.m_menuChangedListener = null;
        }
    }

    @Override
    public void loadChildrenImpl() {
        IType[] menus;
        if (this.m_menuChangedListener == null) {
            this.m_menuChangedListener = new InnerTypePageDirtyListener(this, iMenuType);
            ScoutSdk.addInnerTypeChangedListener((IType)this.getType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
        }
        IType[] iTypeArray = menus = TypeUtility.getInnerTypes((IType)this.getType(), (ITypeFilter)TypeFilters.getSubtypeFilter((IType)iMenuType), (Comparator)TypeComparators.getOrderAnnotationComparator());
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            IType menu = iTypeArray[n2];
            new MenuNodePage(this, menu);
            ++n2;
        }
    }

    @Override
    public Action createEditAction() {
        return null;
    }

    @Override
    public Action createRenameAction() {
        return new TypeRenameAction(this.getOutlineView().getSite().getShell(), "Rename...", this.getType(), "Menu");
    }

    @Override
    public Action createDeleteAction() {
        MemberListDeleteAction action = new MemberListDeleteAction(Texts.get((String)"Action_deleteTypeX", (String[])new String[]{this.getType().getElementName()}), this.getOutlineView().getSite().getShell());
        action.addMemberToDelete((IMember)this.getType());
        action.setImageDescriptor(ScoutSdkUi.getImageDescriptor("menu_remove.png"));
        return action;
    }

    @Override
    public Action createNewAction() {
        MenuNewWizard wizard = new MenuNewWizard();
        wizard.initWizard(this.getType());
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Menu"}), ScoutSdkUi.getImageDescriptor("menu_add.png"), (IWizard)wizard);
    }
}

