/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.MenuNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.ui.wizard.menu.MenuNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;

public class MenuTablePage
extends AbstractPage {
    static final IType iMenuType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.action.menu.IMenu");
    private final IType m_declaringType;
    private InnerTypePageDirtyListener m_menuChangedListener;

    public MenuTablePage(IPage parentPage, IType menuDeclaringType) {
        this.m_declaringType = menuDeclaringType;
        this.setParent(parentPage);
        this.setName(Texts.get((String)"MenuTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("menu.png"));
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_menuChangedListener != null) {
            ScoutSdk.removeInnerTypeChangedListener((IType)this.getDeclaringType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
            this.m_menuChangedListener = null;
        }
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.MenuTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] menues;
        if (this.m_menuChangedListener == null) {
            this.m_menuChangedListener = new InnerTypePageDirtyListener(this, iMenuType);
            ScoutSdk.addInnerTypeChangedListener((IType)this.getDeclaringType(), (IJavaResourceChangedListener)this.m_menuChangedListener);
        }
        IType[] iTypeArray = menues = SdkTypeUtility.getMenus((IType)this.getDeclaringType());
        int n = menues.length;
        int n2 = 0;
        while (n2 < n) {
            IType menu = iTypeArray[n2];
            new MenuNodePage(this, menu);
            ++n2;
        }
    }

    @Override
    public Action createNewAction() {
        MenuNewWizard wizard = new MenuNewWizard();
        wizard.initWizard(this.getDeclaringType());
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Menu"}), ScoutSdkUi.getImageDescriptor("menu_add.png"), (IWizard)wizard);
    }
}

