/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformOutlinesOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.wizard.outline.OutlineNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class OutlineTablePage
extends AbstractPage {
    final IType iOutline = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
    private ICachedTypeHierarchy m_outlineHierarchy;

    public OutlineTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"AllOutlinesTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("outlines.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_outlineHierarchy != null) {
            this.m_outlineHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_outlineHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_outlineHierarchy != null) {
            this.m_outlineHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.OutlineTablePage";
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType[] outlines;
        if (this.m_outlineHierarchy == null) {
            this.m_outlineHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iOutline);
            this.m_outlineHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] iTypeArray = outlines = this.m_outlineHierarchy.getAllSubtypes(this.iOutline, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), TypeComparators.getTypeNameComparator());
        int n = outlines.length;
        int n2 = 0;
        while (n2 < n) {
            IType outline = iTypeArray[n2];
            new OutlineNodePage(this, outline);
            ++n2;
        }
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform all outlines...", (IOperation)new WellformOutlinesOperation(this.getScoutResource())));
    }

    @Override
    public Action createNewAction() {
        OutlineNewWizard wizard = new OutlineNewWizard(this.getScoutResource());
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Outline"}), JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.class_obj.gif"), (IWizard)wizard);
    }
}

