/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.calendar;

import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.calendar.CalendarItemProviderNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypeOrderChangedPageDirtyListener;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.ui.wizard.form.fields.calendarfield.itemprovider.CalendarItemProviderNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;

public class CalendarItemProviderTablePage
extends AbstractPage {
    final IType iCalendarItemProvider = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.basic.calendar.provider.ICalendarItemProvider");
    private InnerTypePageDirtyListener m_innerTypeListener;
    private InnerTypeOrderChangedPageDirtyListener m_orderChangedListener;
    private final IType m_calendarType;

    public CalendarItemProviderTablePage(IPage parent, IType calendarType) {
        super.setParent(parent);
        this.m_calendarType = calendarType;
        this.setName(Texts.get((String)"CalendarItemProducerTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("folder_open.gif"));
    }

    @Override
    public void unloadPage() {
        if (this.m_innerTypeListener != null) {
            ScoutSdk.removeInnerTypeChangedListener((IType)this.getCalendarType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
            this.m_innerTypeListener = null;
        }
        if (this.m_orderChangedListener != null) {
            ScoutSdk.removeJavaResourceChangedListener((IJavaResourceChangedListener)this.m_orderChangedListener);
            this.m_orderChangedListener = null;
        }
        super.unloadPage();
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CalendarItemProviderTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] innerTypes;
        if (this.m_innerTypeListener == null) {
            this.m_innerTypeListener = new InnerTypePageDirtyListener(this, this.iCalendarItemProvider);
            ScoutSdk.addInnerTypeChangedListener((IType)this.getCalendarType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
        }
        if (this.m_orderChangedListener == null) {
            this.m_orderChangedListener = new InnerTypeOrderChangedPageDirtyListener(this, this.iCalendarItemProvider, this.getCalendarType());
            ScoutSdk.addJavaResourceChangedListener((IJavaResourceChangedListener)this.m_orderChangedListener);
        }
        IType[] iTypeArray = innerTypes = SdkTypeUtility.getCalendarItemProviders((IType)this.getCalendarType());
        int n = innerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType provider = iTypeArray[n2];
            CalendarItemProviderNodePage childPage = new CalendarItemProviderNodePage();
            childPage.setParent(this);
            childPage.setType(provider);
            ++n2;
        }
    }

    @Override
    public Action createNewAction() {
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Item Provider"}), ScoutSdkUi.getImageDescriptor("add.png"), (IWizard)new CalendarItemProviderNewWizard(this.getCalendarType()));
    }

    public IType getCalendarType() {
        return this.m_calendarType;
    }
}

