/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form;

import java.util.Comparator;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormHandlerNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.ui.wizard.form.handler.FormHandlerNewWizard;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;

public class FormHandlerTablePage
extends AbstractPage {
    final IType iFormHandler = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IFormHandler");
    private InnerTypePageDirtyListener m_innerTypeListener;
    private final IType m_formType;

    public FormHandlerTablePage(AbstractPage parent, IType formType) {
        this.m_formType = formType;
        this.setParent(parent);
        this.setName(Texts.get((String)"FormHandlersTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("formHandlers.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_innerTypeListener != null) {
            ScoutSdk.removeInnerTypeChangedListener((IType)this.getFormType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
            this.m_innerTypeListener = null;
        }
        super.unloadPage();
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.FormHandlerTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        if (this.m_innerTypeListener == null) {
            this.m_innerTypeListener = new InnerTypePageDirtyListener(this, this.iFormHandler);
            ScoutSdk.addInnerTypeChangedListener((IType)this.getFormType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
        }
        IType[] iTypeArray = TypeUtility.getInnerTypesOrdered((IType)this.getFormType(), (IType)this.iFormHandler, (Comparator)TypeComparators.getTypeNameComparator());
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType formHandlerType = iTypeArray[n2];
            new FormHandlerNodePage(this, formHandlerType);
            ++n2;
        }
    }

    @Override
    public Action createNewAction() {
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Handler"}), ScoutSdkUi.getImageDescriptor("add.png"), (IWizard)new FormHandlerNewWizard(this.getFormType()));
    }

    public IType getFormType() {
        return this.m_formType;
    }
}

