/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form;

import java.util.HashSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformFormsOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.MultipleUpdateFormDataAction;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.wizard.form.FormNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class FormTablePage
extends AbstractPage {
    final IType iForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
    final IType iSearchForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
    private ICachedTypeHierarchy m_formHierarchy;

    public FormTablePage(AbstractPage parent) {
        this.setName(Texts.get((String)"FormTablePage"));
        this.setParent(parent);
    }

    @Override
    public void unloadPage() {
        if (this.m_formHierarchy != null) {
            this.m_formHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_formHierarchy != null) {
            this.m_formHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.FormTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveForms();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            new FormNodePage(this, t);
            ++n2;
        }
    }

    protected IType[] resolveForms() {
        if (this.m_formHierarchy == null) {
            this.m_formHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iForm);
            this.m_formHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] searchForms = this.m_formHierarchy.getAllSubtypes(this.iSearchForm, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()));
        IType[] allSubtypes = this.m_formHierarchy.getAllSubtypes(this.iForm, (ITypeFilter)new P_FormFilter(searchForms, this.getScoutResource().getJavaProject()), TypeComparators.getTypeNameComparator());
        return allSubtypes;
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform all forms...", (IOperation)new WellformFormsOperation(this.getScoutResource())));
        manager.add((IAction)new MultipleUpdateFormDataAction(new ITypeResolver(){

            @Override
            public IType[] getTypes() {
                return FormTablePage.this.resolveForms();
            }
        }));
    }

    @Override
    public Action createNewAction() {
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Form"}), ScoutSdkUi.getImageDescriptor("form_add.png"), (IWizard)new FormNewWizard(this.getScoutResource()));
    }

    private class P_FormFilter
    implements ITypeFilter {
        private HashSet<String> m_searchForms = new HashSet();
        private ITypeFilter m_classesInProjectFilter;

        public P_FormFilter(IType[] searchForms, IJavaProject javaProject) {
            this.m_classesInProjectFilter = TypeFilters.getClassesInProject((IJavaProject)javaProject);
            IType[] iTypeArray = searchForms;
            int n = searchForms.length;
            int n2 = 0;
            while (n2 < n) {
                IType t = iTypeArray[n2];
                this.m_searchForms.add(t.getHandleIdentifier());
                ++n2;
            }
        }

        public boolean accept(IType type) {
            if (!this.m_searchForms.contains(type.getHandleIdentifier())) {
                return this.m_classesInProjectFilter.accept(type);
            }
            return false;
        }
    }
}

