/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformSearchFormsOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.MultipleUpdateFormDataAction;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.FormNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.wizard.form.SearchFormNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class SearchFormTablePage
extends AbstractPage {
    final IType iSearchForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
    private ICachedTypeHierarchy m_searchFormHierarchy;

    public SearchFormTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"SearchFormTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("searchForms.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_searchFormHierarchy != null) {
            this.m_searchFormHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_searchFormHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_searchFormHierarchy != null) {
            this.m_searchFormHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.SearchTablePage";
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveSearchForms();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType searchForm = iTypeArray[n2];
            FormNodePage form = new FormNodePage(this, searchForm);
            form.setImageDescriptor(ScoutSdkUi.getImageDescriptor("searchForm.png"));
            ++n2;
        }
    }

    protected IType[] resolveSearchForms() {
        if (this.m_searchFormHierarchy == null) {
            this.m_searchFormHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iSearchForm);
            this.m_searchFormHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] searchForms = this.m_searchFormHierarchy.getAllSubtypes(this.iSearchForm, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), TypeComparators.getTypeNameComparator());
        return searchForms;
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform all search forms...", (IOperation)new WellformSearchFormsOperation(this.getScoutResource())));
        manager.add((IAction)new MultipleUpdateFormDataAction(new ITypeResolver(){

            @Override
            public IType[] getTypes() {
                return SearchFormTablePage.this.resolveSearchForms();
            }
        }));
    }

    @Override
    public Action createNewAction() {
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Search Form"}), ScoutSdkUi.getImageDescriptor("searchForm_add.png"), (IWizard)new SearchFormNewWizard(this.getScoutResource()));
    }
}

