/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.form.field;

import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.MultipleUpdateFormDataAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.extensions.FormFieldExtensionPoint;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.ITypePage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class FormFieldTemplateTablePage
extends AbstractPage {
    final IType iFormField = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField");
    private ICachedTypeHierarchy m_formFieldHierarchy;

    public FormFieldTemplateTablePage(IPage parent) {
        this.setParent(parent);
        this.setName("Form Fields");
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("default.gif"));
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_formFieldHierarchy != null) {
            this.m_formFieldHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public void unloadPage() {
        if (this.m_formFieldHierarchy != null) {
            this.m_formFieldHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_formFieldHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    protected void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveFormFieldTemplates();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType fieldTemplate = iTypeArray[n2];
            ITypePage nodePage = (ITypePage)FormFieldExtensionPoint.createNodePage(fieldTemplate, (ITypeHierarchy)this.m_formFieldHierarchy);
            nodePage.setParent(this);
            nodePage.setType(fieldTemplate);
            ++n2;
        }
    }

    protected IType[] resolveFormFieldTemplates() {
        if (this.m_formFieldHierarchy == null) {
            this.m_formFieldHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iFormField);
            this.m_formFieldHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.getScoutResource()}), TypeFilters.getFlagsFilter((int)1025)});
        IType[] allSubtypes = this.m_formFieldHierarchy.getAllSubtypes(this.iFormField, filter, TypeComparators.getTypeNameComparator());
        return allSubtypes;
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IAction)new MultipleUpdateFormDataAction(new ITypeResolver(){

            @Override
            public IType[] getTypes() {
                return FormFieldTemplateTablePage.this.resolveFormFieldTemplates();
            }
        }));
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.FormFieldTemplateTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }
}

