/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformWizardsOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.wizard.WizardNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.wizard.wizard.WizardNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class WizardTablePage
extends AbstractPage {
    final IType iWizard = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.wizard.IWizard");
    private ICachedTypeHierarchy m_wizardHierarchy;

    public WizardTablePage(IPage parent) {
        this.setName(Texts.get((String)"WizardTablePage"));
        this.setParent(parent);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("wizzards.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_wizardHierarchy != null) {
            this.m_wizardHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        super.unloadPage();
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_wizardHierarchy != null) {
            this.m_wizardHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.WizardTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] searchForms;
        if (this.m_wizardHierarchy == null) {
            this.m_wizardHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iWizard);
            this.m_wizardHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] iTypeArray = searchForms = this.m_wizardHierarchy.getAllSubtypes(this.iWizard, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), TypeComparators.getTypeNameComparator());
        int n = searchForms.length;
        int n2 = 0;
        while (n2 < n) {
            IType searchForm = iTypeArray[n2];
            new WizardNodePage(this, searchForm);
            ++n2;
        }
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform all wizards...", (IOperation)new WellformWizardsOperation(this.getScoutResource())));
    }

    @Override
    public Action createNewAction() {
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Wizard"}), ScoutSdkUi.getImageDescriptor("wizzard_add.png"), (IWizard)new WizardNewWizard(this.getScoutResource()));
    }
}

