/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server;

import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.commons.CompositeLong;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformServerBundleOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerSessionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.axis.AxisWebServiceConsumerTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.axis.AxisWebServiceProviderTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.CommonServicesNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom.CustomServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup.LookupServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.outline.OutlineServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.process.ProcessServiceTablePage;
import org.eclipse.scout.sdk.ui.internal.wizard.export.ExportServerWarWizard;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class ServerNodePage
extends AbstractPage {
    final IType iService = ScoutSdk.getType((String)"org.eclipse.scout.service.IService");
    final IType iServerSession = ScoutSdk.getType((String)"org.eclipse.scout.rt.server.IServerSession");
    private final IScoutBundle m_serverBundle;
    private ICachedTypeHierarchy m_serverSessionHierarchy;

    public ServerNodePage(IPage parent, IScoutBundle serverBundle) {
        this.setParent(parent);
        this.m_serverBundle = serverBundle;
        this.setName(this.getScoutResource().getSimpleName());
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("serverBundle.png"));
        this.m_serverSessionHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iServerSession);
        this.m_serverSessionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
    }

    @Override
    public void unloadPage() {
        this.m_serverSessionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ServerNodePage";
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return this.m_serverBundle;
    }

    @Override
    public void loadChildrenImpl() {
        try {
            ITypeFilter filter = TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject());
            IType[] serverSessions = this.m_serverSessionHierarchy.getAllSubtypes(this.iServerSession, filter, TypeComparators.getTypeNameComparator());
            if (serverSessions.length > 1) {
                ScoutSdkUi.logError("The server bundle '" + this.getScoutResource().getBundleName() + "' can have in maximum 1 server session.");
            } else if (serverSessions.length == 1) {
                new ServerSessionNodePage(this, serverSessions[0]);
            } else {
                ScoutSdkUi.logInfo("No server session found in server bundle '" + this.getScoutResource().getBundleName() + "'.");
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + ServerSessionNodePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new LookupServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + LookupServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new OutlineServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + OutlineServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new ProcessServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + ProcessServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new CommonServicesNodePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + CommonServicesNodePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new CustomServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + CustomServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new AxisWebServiceConsumerTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + AxisWebServiceConsumerTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
        try {
            new AxisWebServiceProviderTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + AxisWebServiceProviderTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutResource().getBundleName() + "'.", e);
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    protected IType[] resolveServices() {
        IPrimaryTypeTypeHierarchy serviceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iService);
        IType[] services = serviceHierarchy.getAllSubtypes(this.iService, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()));
        return services;
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform server bundle...", (IOperation)new WellformServerBundleOperation(this.getScoutResource())));
        manager.add((IAction)new FormDataSqlBindingValidateAction(new ITypeResolver(){

            @Override
            public IType[] getTypes() {
                return ServerNodePage.this.resolveServices();
            }
        }));
        manager.add((IAction)new WizardAction("Export as WAR file...", ScoutSdkUi.getImageDescriptor("serverBundle_export.png"), (IWizard)new ExportServerWarWizard(this.getScoutResource())));
    }

    private IType resolveType(final String fqn) throws CoreException {
        final TreeMap matchList = new TreeMap();
        String fastPat = fqn;
        int i = fastPat.lastIndexOf(46);
        if (i >= 0) {
            fastPat = fastPat.substring(i + 1);
        }
        new SearchEngine().search(SearchPattern.createPattern((String)fastPat, (int)0, (int)0, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getScoutResource().getJavaProject()}, (int)9), new SearchRequestor(){

            public final void acceptSearchMatch(SearchMatch match) throws CoreException {
                TypeDeclarationMatch typeMatch;
                IType t;
                if (match instanceof TypeDeclarationMatch && (t = (IType)(typeMatch = (TypeDeclarationMatch)match).getElement()).getFullyQualifiedName('.').indexOf(fqn) >= 0) {
                    matchList.put(new CompositeLong((long)(t.isBinary() ? 1 : 0), (long)matchList.size()), t);
                }
            }
        }, null);
        if (matchList.size() > 1) {
            ScoutSdk.logWarning((String)("found more than one type matches for '" + fqn + "' (matches: '" + matchList.size() + "')."));
        } else if (matchList.size() < 1) {
            ScoutSdk.logWarning((String)("found no type matches for '" + fqn + "'."));
            return null;
        }
        return (IType)matchList.firstEntry().getValue();
    }
}

