/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.SharedContextPropertyTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;

public class ServerSessionNodePage
extends AbstractScoutTypePage {
    final IType iClientSession = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.IClientSession");

    public ServerSessionNodePage(IPage parent, IType type) {
        this.setParent(parent);
        this.setType(type);
        this.setName("Server Session");
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("serverSession.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ServerSessionNodePage";
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    protected void loadChildrenImpl() {
        IScoutBundle clientBundle = this.getScoutResource().getScoutProject().getClientBundle();
        if (clientBundle != null) {
            ITypeFilter filter;
            IPrimaryTypeTypeHierarchy clientSessionHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iClientSession);
            IType[] allClientSessions = clientSessionHierarchy.getAllSubtypes(this.iClientSession, filter = TypeFilters.getClassesInProject((IJavaProject)clientBundle.getJavaProject()), TypeComparators.getTypeNameComparator());
            if (allClientSessions.length > 1) {
                ScoutSdkUi.logError("a client bundle '" + clientBundle + "' can have in maximum 1 client session");
            } else if (allClientSessions.length == 1) {
                IType clientSession = allClientSessions[0];
                new SharedContextPropertyTablePage(this, clientSession, this.getType());
            } else {
                ScoutSdkUi.logInfo("could not find a client session in bundle '" + clientBundle.getBundleName() + "'.");
            }
        } else {
            ScoutSdkUi.logInfo("could not find a client bundle name-correspondig to '" + this.getScoutResource().getBundleName() + "'.");
        }
    }
}

