/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.axis;

import java.util.HashSet;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.AxisWebServiceConsumerNewAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.axis.AxisWebServiceConsumerNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class AxisWebServiceConsumerTablePage
extends AbstractPage {
    private static final String SERVICE_INTERFACE_NAME = "org.apache.axis.client.Service";
    private static final String SERVICE_SKELETON_NAME = "org.apache.axis.wsdl.Skeleton";
    private IType m_interfaceType;
    private IType m_skeletonType;
    private ITypeHierarchyChangedListener m_temporaryGlobalInterfaceListener;
    private ITypeHierarchyChangedListener m_temporaryGlobalSkeletonListener;
    private ICachedTypeHierarchy m_skeletonHierarchy;
    private ICachedTypeHierarchy m_axisServcieHierarchy;
    private P_AxisLibraryListener m_libraryDetector;

    public AxisWebServiceConsumerTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"AxisWebServiceConsumerTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("serviceLocators.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.AxisWebServiceConsumerTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    protected boolean checkInterfaceAvailability() {
        if (this.m_interfaceType == null) {
            this.m_interfaceType = ScoutSdk.getType((String)SERVICE_INTERFACE_NAME);
            if (TypeUtility.exists((IJavaElement)this.m_interfaceType)) {
                this.m_axisServcieHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.m_interfaceType);
                this.m_axisServcieHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
                if (this.m_libraryDetector != null) {
                    JavaCore.removeElementChangedListener((IElementChangedListener)this.m_libraryDetector);
                    this.m_libraryDetector = null;
                }
            } else {
                if (this.m_libraryDetector == null) {
                    this.m_libraryDetector = new P_AxisLibraryListener();
                    JavaCore.addElementChangedListener((IElementChangedListener)this.m_libraryDetector);
                }
                return false;
            }
        }
        if (this.m_skeletonType == null) {
            this.m_skeletonType = ScoutSdk.getType((String)SERVICE_SKELETON_NAME);
            if (TypeUtility.exists((IJavaElement)this.m_skeletonType)) {
                this.m_skeletonHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.m_skeletonType);
                this.m_skeletonHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
                if (this.m_libraryDetector != null) {
                    JavaCore.removeElementChangedListener((IElementChangedListener)this.m_libraryDetector);
                    this.m_libraryDetector = null;
                }
            } else {
                if (this.m_libraryDetector == null) {
                    this.m_libraryDetector = new P_AxisLibraryListener();
                    JavaCore.addElementChangedListener((IElementChangedListener)this.m_libraryDetector);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IType type;
        int n;
        int n2;
        IType[] iTypeArray;
        if (!this.checkInterfaceAvailability()) {
            return;
        }
        HashSet<String> providerPackages = new HashSet<String>();
        if (TypeUtility.exists((IJavaElement)this.m_skeletonType)) {
            IType[] skeletons;
            iTypeArray = skeletons = this.m_skeletonHierarchy.getAllSubtypes(this.m_skeletonType, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()));
            n2 = skeletons.length;
            n = 0;
            while (n < n2) {
                type = iTypeArray[n];
                providerPackages.add(type.getPackageFragment().getElementName());
                ++n;
            }
        }
        if (TypeUtility.exists((IJavaElement)this.m_interfaceType)) {
            IType[] interfaces;
            iTypeArray = interfaces = this.m_axisServcieHierarchy.getAllSubtypes(this.m_interfaceType, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()));
            n2 = interfaces.length;
            n = 0;
            while (n < n2) {
                type = iTypeArray[n];
                if (!providerPackages.contains(type.getPackageFragment().getElementName())) {
                    new AxisWebServiceConsumerNodePage(this, type);
                }
                ++n;
            }
        }
    }

    @Override
    public Action createNewAction() {
        return new AxisWebServiceConsumerNewAction(this.getOutlineView().getSite().getShell(), this.getScoutResource());
    }

    private class P_AxisLibraryListener
    implements IElementChangedListener {
        private P_AxisLibraryListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            this.visitDelta(e.getDelta());
        }

        private void visitDelta(IJavaElementDelta delta) {
            IPackageFragmentRoot frag;
            int flags = delta.getFlags();
            IJavaElement e = delta.getElement();
            if ((flags & 8) != 0) {
                IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                    this.visitDelta(childDelta);
                    ++n2;
                }
            } else if (delta.getKind() == 4 && e.getElementType() == 3 && (frag = (IPackageFragmentRoot)e).isArchive() && frag.getElementName().contains("axis")) {
                AxisWebServiceConsumerTablePage.this.markStructureDirty();
            }
        }
    }
}

