/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.axis.util;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.commons.holders.ObjectHolder;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.axis.util.FileListViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FileListDialog
extends TitleAreaDialog {
    private FileListViewer m_viewer;

    public static List<IFile> showThreadSafe(final String title, final String subTitle, final String message, final List<IFile> files) {
        if (ScoutSdkUi.getDisplay().getThread() == Thread.currentThread()) {
            return FileListDialog.show(ScoutSdkUi.getShell(), title, subTitle, message, files);
        }
        final ObjectHolder result = new ObjectHolder();
        ScoutSdkUi.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result.setValue(FileListDialog.show(ScoutSdkUi.getShell(), title, subTitle, message, files));
            }
        });
        return (List)result.getValue();
    }

    public static List<IFile> show(Shell shell, String title, String subTitle, String message, List<IFile> files) {
        if (shell == null) {
            shell = new Shell();
        }
        FileListDialog dialog = new FileListDialog(shell);
        dialog.create();
        dialog.getShell().setText(title);
        dialog.setTitle(subTitle);
        dialog.setMessage(message, 1);
        dialog.getFileListViewer().setFiles(files);
        dialog.getShell().setSize(800, 600);
        if (dialog.open() == 0) {
            return dialog.getFileListViewer().getCheckedFiles();
        }
        return null;
    }

    public FileListDialog(Shell parent) {
        super(parent);
    }

    public FileListViewer getFileListViewer() {
        return this.m_viewer;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.m_viewer = new FileListViewer(c, 0);
        this.m_viewer.setLayoutData(new GridData(4, 4, true, true));
        return c;
    }

    protected void okPressed() {
        this.getFileListViewer().saveResult();
        super.okPressed();
    }
}

