/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.axis.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class FileListViewer
extends Composite {
    private List<IFile> m_files = new ArrayList<IFile>(0);
    private List<IFile> m_result = new ArrayList<IFile>(0);
    private CheckboxTableViewer m_viewer;

    public FileListViewer(Composite parent, int style) {
        super(parent, style);
        this.createPartControl(this);
    }

    public void setFiles(List<IFile> files) {
        this.m_files = files;
        this.sortTable(2, true);
        this.sortTable(1, true);
        this.m_viewer.setAllChecked(true);
    }

    public List<IFile> getFiles() {
        return this.m_files;
    }

    public void saveResult() {
        ArrayList<IFile> list = new ArrayList<IFile>();
        TableItem[] tableItemArray = this.m_viewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                list.add((IFile)item.getData());
            }
            ++n2;
        }
        this.m_result = list;
    }

    public List<IFile> getCheckedFiles() {
        return this.m_result;
    }

    protected void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new RowLayout(256));
        Button checkAllButton = new Button(buttons, 0);
        checkAllButton.setLayoutData((Object)new RowData());
        checkAllButton.setText("Check all");
        checkAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileListViewer.this.m_viewer.setAllChecked(true);
            }
        });
        Button uncheckAllButton = new Button(buttons, 0);
        uncheckAllButton.setLayoutData((Object)new RowData());
        uncheckAllButton.setText("Uncheck all");
        uncheckAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileListViewer.this.m_viewer.setAllChecked(false);
            }
        });
        Table table = new Table(parent, 68386);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_viewer = new CheckboxTableViewer(table);
        while (table.getColumnCount() > 0) {
            table.getColumn(0).dispose();
        }
        new TableColumn(table, 16384);
        new TableColumn(table, 16384);
        new TableColumn(table, 16384);
        new TableColumn(table, 16384);
        table.getColumn(0).setData("index", (Object)0);
        table.getColumn(1).setData("index", (Object)1);
        table.getColumn(2).setData("index", (Object)2);
        table.getColumn(3).setData("index", (Object)3);
        TableSortAdapter sortAdapter = new TableSortAdapter();
        table.getColumn(0).addSelectionListener((SelectionListener)sortAdapter);
        table.getColumn(1).addSelectionListener((SelectionListener)sortAdapter);
        table.getColumn(2).addSelectionListener((SelectionListener)sortAdapter);
        table.getColumn(3).addSelectionListener((SelectionListener)sortAdapter);
        table.getColumn(0).setWidth(32);
        table.getColumn(1).setText("Path");
        table.getColumn(1).setWidth(320);
        table.getColumn(2).setText("Resource");
        table.getColumn(2).setWidth(250);
        table.getColumn(3).setText("Problems");
        table.getColumn(3).setWidth(80);
        table.setHeaderVisible(true);
        this.m_viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.m_viewer.setInput((Object)"default");
    }

    public boolean setFocus() {
        return this.m_viewer.getControl().setFocus();
    }

    public void setInput(Object input) {
        this.m_viewer.setInput(input);
    }

    public void sortTable(int columnIndex, boolean ascending) {
        Table table = this.m_viewer.getTable();
        TableColumn col = table.getColumn(columnIndex);
        ViewLabelProvider labelProvider = (ViewLabelProvider)this.m_viewer.getLabelProvider();
        Collator coll = Collator.getInstance();
        TreeMap<CompositeObject, IFile> sortMap = new TreeMap<CompositeObject, IFile>();
        int index = 0;
        for (IFile f : this.m_files) {
            String text = null;
            if (columnIndex > 0) {
                text = labelProvider.getColumnText(f, columnIndex);
            } else if (index < table.getItemCount()) {
                text = table.getItem(index).getChecked() ? "X" : "";
            }
            sortMap.put(new CompositeObject(new Object[]{coll.getCollationKey(text), ascending ? index : this.m_files.size() - 1 - index}), f);
            ++index;
        }
        if (ascending) {
            this.m_files = new ArrayList(sortMap.values());
        } else {
            this.m_files = new ArrayList<IFile>(sortMap.size());
            ListIterator it = new ArrayList(sortMap.values()).listIterator(sortMap.size());
            while (it.hasPrevious()) {
                this.m_files.add((IFile)it.previous());
            }
        }
        table.setSortColumn(col);
        table.setSortDirection(ascending ? 128 : 1024);
        this.m_viewer.refresh();
    }

    private class TableSortAdapter
    extends SelectionAdapter {
        private TableSortAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.widget;
            int direction = col.getParent().getSortColumn() == col ? (col.getParent().getSortDirection() == 128 ? 1024 : 128) : 128;
            FileListViewer.this.sortTable((Integer)col.getData("index"), direction == 128);
        }
    }

    private class ViewContentProvider
    implements IStructuredContentProvider {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return FileListViewer.this.m_files.toArray(new IFile[FileListViewer.this.m_files.size()]);
        }
    }

    private class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            IFile f = (IFile)obj;
            switch (index) {
                case 0: {
                    return null;
                }
                case 1: {
                    return f.getFullPath().removeLastSegments(1).toString();
                }
                case 2: {
                    return f.getName();
                }
                case 3: {
                    return f.exists() ? "File exists" : "";
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            IFile f = (IFile)obj;
            switch (index) {
                case 0: {
                    return null;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
                case 3: {
                    return f.exists() ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK") : null;
                }
            }
            return null;
        }
    }
}

