/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom;

import java.util.Comparator;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.custom.CustomServiceNodePage;
import org.eclipse.scout.sdk.ui.type.PackageContentChangedListener;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.wizard.services.CustomServiceNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchy;

public class CustomServicePackageNodePage
extends AbstractPage {
    final IType iService = ScoutSdk.getType((String)"org.eclipse.scout.service.IService");
    private PackageContentChangedListener m_packageContentListener;
    private IPackageFragment m_package;
    private IPrimaryTypeTypeHierarchy m_serviceHierarchy;

    public CustomServicePackageNodePage(AbstractPage parent, IPackageFragment packageFrament) {
        this.m_package = packageFrament;
        this.setParent(parent);
        this.m_packageContentListener = new PackageContentChangedListener(this, this.m_package);
        JavaCore.addElementChangedListener((IElementChangedListener)this.m_packageContentListener);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("package_obj.gif"));
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.m_packageContentListener);
        this.m_serviceHierarchy = null;
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CustomServicePackageNodePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    protected void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveServices();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType service = iTypeArray[n2];
            IType serviceInterface = null;
            IType[] interfaces = this.m_serviceHierarchy.getSuperInterfaces(service, TypeFilters.getElementNameFilter((String)("I" + service.getElementName())));
            if (interfaces.length > 0) {
                serviceInterface = interfaces[0];
            }
            new CustomServiceNodePage(this, service, serviceInterface);
            ++n2;
        }
    }

    protected IType[] resolveServices() {
        if (this.m_serviceHierarchy == null) {
            this.m_serviceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iService);
        }
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassFilter(), TypeFilters.getSubtypeFilter((IType)this.iService, (ITypeHierarchy)this.m_serviceHierarchy)});
        IType[] services = TypeUtility.getTypesInPackage((IPackageFragment)this.m_package, (ITypeFilter)filter, (Comparator)TypeComparators.getTypeNameComparator());
        return services;
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IAction)new FormDataSqlBindingValidateAction(new ITypeResolver(){

            @Override
            public IType[] getTypes() {
                return CustomServicePackageNodePage.this.resolveServices();
            }
        }));
    }

    @Override
    public Action createNewAction() {
        CustomServiceNewWizard wizard = new CustomServiceNewWizard(this.getScoutResource(), this.m_package);
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Custom Service"}), ScoutSdkUi.getImageDescriptor("service_add.png"), (IWizard)wizard);
    }
}

