/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.action.validation.ITypeResolver;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup.LookupServiceNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.wizard.services.LookupServiceNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class LookupServiceTablePage
extends AbstractPage {
    final IType iLookupService = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService");
    ICachedTypeHierarchy m_serviceHierarchy;

    public LookupServiceTablePage(AbstractPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"LookupServiceTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("services.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.LookupServiceTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_serviceHierarchy != null) {
            this.m_serviceHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] iTypeArray = this.resolveAllLookupServices();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType service = iTypeArray[n2];
            new LookupServiceNodePage(this, service, this.iLookupService);
            ++n2;
        }
    }

    protected IType[] resolveAllLookupServices() {
        if (this.m_serviceHierarchy == null) {
            this.m_serviceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iLookupService);
            this.m_serviceHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        IType[] services = this.m_serviceHierarchy.getAllSubtypes(this.iLookupService, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), TypeComparators.getTypeNameComparator());
        return services;
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IAction)new FormDataSqlBindingValidateAction(new ITypeResolver(){

            @Override
            public IType[] getTypes() {
                return LookupServiceTablePage.this.resolveAllLookupServices();
            }
        }));
    }

    @Override
    public Action createNewAction() {
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Lookup Service"}), JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.class_obj.gif"), (IWizard)new LookupServiceNewWizard(this.getScoutResource()));
    }

    private class P_HierarchyListener
    implements ITypeHierarchyChangedListener {
        private P_HierarchyListener() {
        }

        public void handleEvent(int eventType, IType type) {
            switch (eventType) {
                case 2: 
                case 4: 
                case 5: {
                    if (!LookupServiceTablePage.this.m_serviceHierarchy.isSubtype(LookupServiceTablePage.this.iLookupService, type)) break;
                    LookupServiceTablePage.this.markStructureDirty();
                }
            }
        }
    }
}

