/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.action.delete.MemberListDeleteAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.InnerTypePageDirtyListener;
import org.eclipse.scout.sdk.ui.wizard.code.CodeNewWizard;
import org.eclipse.scout.sdk.util.ScoutSourceUtilities;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;

public class CodeTypeNodePage
extends AbstractScoutTypePage {
    final IType iCode = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICode");
    private InnerTypePageDirtyListener m_innerTypeListener;

    public CodeTypeNodePage(IPage parent, IType type) {
        this.setParent(parent);
        this.setType(type);
        this.setName(ScoutSourceUtilities.getTranslatedMethodStringValue((IType)this.getType(), (String)"getConfiguredText"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("codeType.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CodeTypeNodePage";
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void unloadPage() {
        super.unloadPage();
        if (this.m_innerTypeListener != null) {
            ScoutSdk.removeInnerTypeChangedListener((IType)this.getType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
            this.m_innerTypeListener = null;
        }
    }

    @Override
    public void loadChildrenImpl() {
        IType[] codes;
        if (this.m_innerTypeListener == null) {
            this.m_innerTypeListener = new InnerTypePageDirtyListener(this, this.iCode);
            ScoutSdk.addInnerTypeChangedListener((IType)this.getType(), (IJavaResourceChangedListener)this.m_innerTypeListener);
        }
        IType[] iTypeArray = codes = SdkTypeUtility.getCodes((IType)this.getType());
        int n = codes.length;
        int n2 = 0;
        while (n2 < n) {
            IType code = iTypeArray[n2];
            new CodeNodePage(this, code);
            ++n2;
        }
    }

    @Override
    public Action createDeleteAction() {
        MemberListDeleteAction typeDeleteAction = new MemberListDeleteAction("Delete", ScoutSdkUi.getShell());
        typeDeleteAction.setImageDescriptor(ScoutSdkUi.getImageDescriptor("codeType_remove.png"));
        typeDeleteAction.addMemberToDelete((IMember)this.getType());
        return typeDeleteAction;
    }

    @Override
    public Action createNewAction() {
        CodeNewWizard wizard = new CodeNewWizard();
        wizard.initWizard(this.getType());
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Code"}), ScoutSdkUi.getImageDescriptor("code_add.png"), (IWizard)wizard);
    }
}

