/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformCodeTypesOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.WizardAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeTypeNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.wizard.code.type.CodeTypeNewWizard;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeComparators;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchyChangedListener;

public class CodeTypeTablePage
extends AbstractPage {
    final IType iCodeType = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICodeType");
    private ICachedTypeHierarchy m_codeTypeHierarchy;

    public CodeTypeTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"EnumerationTablePage"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("codeTypes.png"));
    }

    @Override
    public void unloadPage() {
        if (this.m_codeTypeHierarchy != null) {
            this.m_codeTypeHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.CodeTypeTablePage";
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache && this.m_codeTypeHierarchy != null) {
            this.m_codeTypeHierarchy.invalidate();
        }
        super.refresh(clearCache);
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    @Override
    public void loadChildrenImpl() {
        IType[] codeTypes;
        if (this.m_codeTypeHierarchy == null) {
            this.m_codeTypeHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iCodeType);
            this.m_codeTypeHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        ITypeFilter filter = TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject());
        IType[] iTypeArray = codeTypes = this.m_codeTypeHierarchy.getAllSubtypes(this.iCodeType, filter, TypeComparators.getTypeNameComparator());
        int n = codeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType codeType = iTypeArray[n2];
            new CodeTypeNodePage(this, codeType);
            ++n2;
        }
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform all code types...", (IOperation)new WellformCodeTypesOperation(this.getScoutResource())));
    }

    @Override
    public Action createNewAction() {
        return new WizardAction(Texts.get((String)"Action_newTypeX", (String[])new String[]{"Codetpye"}), ScoutSdkUi.getImageDescriptor("codeType_add.png"), (IWizard)new CodeTypeNewWizard(this.getScoutResource()));
    }
}

