/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import java.util.ArrayList;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.NamingUtility;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.delete.MemberListDeleteAction;
import org.eclipse.scout.sdk.ui.action.rename.PropertyBeansRenameAction;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.member.IPropertyBean;

public class SharedContextPropertyNodePage
extends AbstractPage {
    private final IPropertyBean m_serverDesc;
    private final IPropertyBean m_clientDesc;

    public SharedContextPropertyNodePage(IPage parent, IPropertyBean clientDesc, IPropertyBean serverDesc) {
        this.setParent(parent);
        this.m_clientDesc = clientDesc;
        this.m_serverDesc = serverDesc;
        IPropertyBean desc = this.getServerDesc();
        if (desc == null) {
            desc = this.getClientDesc();
        }
        this.setName(String.valueOf(NamingUtility.toVariableName((String)desc.getBeanName())) + " (" + Signature.getSignatureSimpleName((String)desc.getBeanSignature()) + ")");
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("variable.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.SharedContextPropertyNodePage";
    }

    @Override
    public Action createRenameAction() {
        ArrayList<IPropertyBean> descs = new ArrayList<IPropertyBean>();
        if (this.getClientDesc() != null) {
            descs.add(this.getClientDesc());
        }
        if (this.getServerDesc() != null) {
            descs.add(this.getServerDesc());
        }
        return new PropertyBeansRenameAction(this.getOutlineView().getSite().getShell(), "Rename...", descs.toArray(new IPropertyBean[descs.size()]));
    }

    @Override
    public Action createDeleteAction() {
        IMember m;
        int n;
        int n2;
        IMember[] iMemberArray;
        MemberListDeleteAction action = new MemberListDeleteAction("Delete " + this.getName(), ScoutSdkUi.getShell());
        if (this.getServerDesc() != null) {
            iMemberArray = this.getServerDesc().getAllMembers();
            n2 = iMemberArray.length;
            n = 0;
            while (n < n2) {
                m = iMemberArray[n];
                action.addMemberToDelete(m);
                ++n;
            }
        }
        if (this.getClientDesc() != null) {
            iMemberArray = this.getClientDesc().getAllMembers();
            n2 = iMemberArray.length;
            n = 0;
            while (n < n2) {
                m = iMemberArray[n];
                action.addMemberToDelete(m);
                ++n;
            }
        }
        action.setImageDescriptor(ScoutSdkUi.getImageDescriptor("variable_remove.png"));
        return action;
    }

    public IPropertyBean getServerDesc() {
        return this.m_serverDesc;
    }

    public IPropertyBean getClientDesc() {
        return this.m_clientDesc;
    }
}

