/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.wellform.WellformSharedBundleOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.CodeTypeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.IconNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.LookupCallTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.NlsTextsNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.shared.PermissionTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;

public class SharedNodePage
extends AbstractPage {
    final IType abstractIcons = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.AbstractIcons");
    private final IScoutBundle m_sharedProject;

    public SharedNodePage(IPage parent, IScoutBundle sharedProject) {
        this.setParent(parent);
        this.m_sharedProject = sharedProject;
        this.setName(this.getScoutResource().getSimpleName());
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("sharedBundle.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.SharedNodePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IScoutBundle getScoutResource() {
        return this.m_sharedProject;
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        IPrimaryTypeTypeHierarchy iconHierarchy;
        IType[] iconTypes;
        if (this.getScoutResource().getScoutProject().getIconProvider() != null && (iconTypes = (iconHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.abstractIcons)).getAllSubtypes(this.abstractIcons, TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject()), null)).length > 0) {
            new IconNodePage(this, iconTypes[0]);
        }
        if (this.getScoutResource().getScoutProject().getNlsProject() != null) {
            new NlsTextsNodePage(this);
        }
        new PermissionTablePage(this);
        new CodeTypeTablePage(this);
        try {
            new LookupCallTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("could not create LookupCallTablePage in project '" + this.getScoutResource().getRootPackageName() + "'", e);
        }
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new WellformAction(this.getOutlineView().getSite().getShell(), "Wellform shared bundle...", (IOperation)new WellformSharedBundleOperation(this.getScoutResource())));
    }
}

