/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.sdk.ui.IScoutConstants;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.extensions.view.property.IMultiPropertyViewPart;
import org.eclipse.scout.sdk.ui.extensions.view.property.IPropertyViewPart;
import org.eclipse.scout.sdk.ui.extensions.view.property.ISinglePropertyViewPart;
import org.eclipse.scout.sdk.ui.internal.extensions.view.property.PropertyViewExtensionPoint;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.ExceptionSinglePagePropertyViewPart;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.UnknownSinglePagePropertyViewPart;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ScoutPropertyView
extends ViewPart {
    private HashCodeComparator hasCodeComparator = new HashCodeComparator();
    private Composite m_content;
    private IPropertyViewPart m_currentPart = null;
    private P_SelectionListener m_selectionListener;
    private IMemento m_memento;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        if (this.m_selectionListener == null) {
            this.m_selectionListener = new P_SelectionListener();
        }
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(IScoutConstants.SCOUT_EXPLORER_VIEW, (ISelectionListener)this.m_selectionListener);
    }

    public void dispose() {
        if (this.m_currentPart != null) {
            this.m_currentPart.save(this.m_memento);
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(IScoutConstants.SCOUT_EXPLORER_VIEW, (ISelectionListener)this.m_selectionListener);
        this.m_selectionListener = null;
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.m_content = new Composite(parent, 0);
        this.m_content.setLayout((Layout)new FillLayout());
        ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection(IScoutConstants.SCOUT_EXPLORER_VIEW);
        this.handleSelectionChanged(selection);
    }

    public void setFocus() {
        this.m_content.setFocus();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.m_memento = memento;
        super.init(site, memento);
    }

    /*
     * Unable to fully structure code
     */
    protected void handleSelectionChanged(ISelection selection) {
        block18: {
            block19: {
                pagesa = this.getPagesOfSelection(selection);
                if (this.m_currentPart != null) {
                    if (this.m_currentPart instanceof IMultiPropertyViewPart) {
                        currentPart = (IMultiPropertyViewPart)this.m_currentPart;
                        if (this.equalPagesIgnoreOrder(pagesa, currentPart.getPages())) {
                            return;
                        }
                    } else if (this.m_currentPart instanceof ISinglePropertyViewPart) {
                        currentPart = (ISinglePropertyViewPart)this.m_currentPart;
                        if (pagesa != null && pagesa.length == 1 && pagesa[0].equals(currentPart.getPage())) {
                            return;
                        }
                    }
                    this.m_currentPart.save(this.m_memento);
                    this.m_currentPart.dispose();
                }
                try {
                    if (pagesa == null) {
                        this.m_currentPart = new UnknownSinglePagePropertyViewPart();
                        this.m_currentPart.createPart(this.m_content);
                    } else if (pagesa.length == 1) {
                        singlePart = PropertyViewExtensionPoint.createSinglePageViewPart(pagesa[0]);
                        singlePart.setPage(pagesa[0]);
                        this.m_currentPart = singlePart;
                        singlePart.createPart(this.m_content);
                    } else if (pagesa.length > 1) {
                        multiPart = PropertyViewExtensionPoint.createMultiPageViewPart(pagesa);
                        this.m_currentPart = multiPart;
                        if (multiPart != null) {
                            multiPart.setPages(pagesa);
                            multiPart.createPart(this.m_content);
                        }
                    }
                    break block18;
                }
                catch (Throwable e) {
                    if (this.m_currentPart != null) {
                        this.m_currentPart.dispose();
                        this.m_currentPart = null;
                    }
                    selectionBuilder = new StringBuilder();
                    selectionBuilder.append("[");
                    if (pagesa == null) break block19;
                    i = 0;
                    ** while (i < pagesa.length)
                }
lbl-1000:
                // 1 sources

                {
                    selectionBuilder.append(pagesa[i].getName());
                    if (i < pagesa.length - 1) {
                        selectionBuilder.append(", ");
                    }
                    ++i;
                    continue;
                }
            }
            selectionBuilder.append("]");
            ScoutSdkUi.logError("error during create property pages for " + selectionBuilder.toString(), e);
            this.m_currentPart = new ExceptionSinglePagePropertyViewPart();
            ((ExceptionSinglePagePropertyViewPart)this.m_currentPart).setThrowable(e);
            this.m_currentPart.createPart(this.m_content);
        }
        if (this.m_currentPart != null) {
            this.m_currentPart.init(this.m_memento);
        }
        this.m_content.layout(false);
    }

    private IPage[] getPagesOfSelection(ISelection selection) {
        ArrayList<IPage> pages = new ArrayList<IPage>(3);
        if (selection instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)selection;
            for (Object element : sel.toList()) {
                if (!(element instanceof IPage)) continue;
                pages.add((IPage)element);
            }
        }
        return pages.toArray(new IPage[pages.size()]);
    }

    private boolean equalPagesIgnoreOrder(IPage[] pagesA, IPage[] pagesB) {
        if (pagesA == null && pagesB == null) {
            return true;
        }
        if (pagesA == null || pagesB == null) {
            return false;
        }
        Arrays.sort(pagesA, this.hasCodeComparator);
        Arrays.sort(pagesB, this.hasCodeComparator);
        return Arrays.equals(pagesA, pagesB);
    }

    private class HashCodeComparator
    implements Comparator<Object> {
        private HashCodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.hashCode() - o2.hashCode();
        }
    }

    private class P_SelectionListener
    implements ISelectionListener {
        private P_SelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            ScoutPropertyView.this.handleSelectionChanged(selection);
        }
    }
}

