/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.model.links;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.ILink;

public class LinkGroup {
    private int m_order;
    private String m_name;
    private ArrayList<ILink> m_links = new ArrayList();

    public LinkGroup(String name, int order) {
        this.m_name = name;
        this.m_order = order;
    }

    public boolean isEmpty() {
        return this.m_links.isEmpty();
    }

    public int getOrder() {
        return this.m_order;
    }

    public String getName() {
        return this.m_name;
    }

    public void addLink(ILink link) {
        this.m_links.add(link);
    }

    public boolean removeLink(ILink link) {
        return this.m_links.remove(link);
    }

    public ILink[] getLinks() {
        return this.m_links.toArray(new ILink[this.m_links.size()]);
    }

    private class P_LinkComparator
    implements Comparator<ILink> {
        private P_LinkComparator() {
        }

        @Override
        public int compare(ILink o1, ILink o2) {
            int diff = o1.getOrderNumber() - o2.getOrderNumber();
            if (diff == 0) {
                diff = o1.getName() != null && o2.getName() != null ? o1.getName().compareTo(o2.getName()) : o1.hashCode() - o2.hashCode();
            }
            return diff;
        }
    }
}

