/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.jdt.signature.IImportValidator;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.method.MethodOverrideOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.properties.presenter.ExecMethodPresenter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExecResetSerchFilterMethodPresenter
extends ExecMethodPresenter {
    public ExecResetSerchFilterMethodPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void overrideMethod() {
        if (!this.getMethod().isImplemented()) {
            try {
                P_OverrideExecResetSearchFilterMethod methodOverrideOperation = new P_OverrideExecResetSearchFilterMethod(this.getMethod().getType(), this.getMethod().getMethodName());
                OperationJob job = new OperationJob((IOperation)methodOverrideOperation);
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {}
                if (methodOverrideOperation.getCreatedMethod() != null) {
                    this.showJavaElementInEditor((IJavaElement)methodOverrideOperation.getCreatedMethod());
                }
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logWarning("could not override the method '" + this.getMethod().getMethodName() + "' on '" + this.getMethod().getType() + "'", e);
            }
        }
    }

    private class P_OverrideExecResetSearchFilterMethod
    extends MethodOverrideOperation {
        private final IType iForm;
        private final IType iSearchForm;
        private IType m_formDataType;
        private IType m_formType;

        public P_OverrideExecResetSearchFilterMethod(IType declaringType, String methodName) throws JavaModelException {
            super(declaringType, methodName, true);
            this.iForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
            this.iSearchForm = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
            this.m_formDataType = null;
            this.m_formType = declaringType;
            IPrimaryTypeTypeHierarchy formHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)this.iForm);
            if (TypeUtility.exists((IJavaElement)this.m_formType) && formHierarchy.isSubtype(this.iSearchForm, this.m_formType)) {
                String formDataSimpleName = this.m_formType.getElementName().replaceAll("Form$", "FormData");
                IScoutBundle clientBundle = SdkTypeUtility.getScoutBundle((IJavaElement)this.getDeclaringType());
                IScoutBundle[] iScoutBundleArray = clientBundle.getRequiredBundles(ScoutBundleFilters.getSharedFilter(), false);
                int n = iScoutBundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IScoutBundle shared = iScoutBundleArray[n2];
                    String formDataFqn = String.valueOf(shared.getPackageName(".services.process")) + "." + formDataSimpleName;
                    if (ScoutSdk.existsType((String)formDataFqn)) {
                        this.m_formDataType = ScoutSdk.getType((String)formDataFqn);
                        break;
                    }
                    ++n2;
                }
            }
        }

        protected String createMethodBody(IImportValidator validator) throws JavaModelException {
            if (this.m_formDataType != null && this.m_formType != null) {
                StringBuilder content = new StringBuilder();
                content.append("super.execResetSearchFilter(searchFilter);\n");
                String simpleFormDataName = validator.getSimpleTypeRef(Signature.createTypeSignature((String)this.m_formDataType.getFullyQualifiedName(), (boolean)true));
                content.append(String.valueOf(simpleFormDataName) + " formData = new " + simpleFormDataName + "();\n");
                content.append("exportFormData(formData);\n");
                content.append("searchFilter.setFormData(formData);");
                return content.toString();
            }
            return super.createMethodBody(validator);
        }
    }
}

