/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.ILink;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinkGroup;
import org.eclipse.scout.sdk.ui.internal.view.properties.model.links.LinksPresenterModel;
import org.eclipse.scout.sdk.ui.view.properties.presenter.AbstractPresenter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class LinksPresenter
extends AbstractPresenter {
    private LinksPresenterModel m_linksProperty;

    public LinksPresenter(FormToolkit toolkit, Composite parent) {
        this(toolkit, parent, null);
    }

    public LinksPresenter(FormToolkit toolkit, Composite parent, LinksPresenterModel linksProperty) {
        super(toolkit, parent);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        this.getContainer().setLayout((Layout)layout);
        this.setLinksProperty(linksProperty);
    }

    @Override
    public void dispose() {
        super.dispose();
        Object[] objectArray = this.m_linksProperty.getOrderdGlobalLinks();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILink l = objectArray[n2];
            l.dispose();
            ++n2;
        }
        objectArray = this.m_linksProperty.getOrderedNotEmtyGroups();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object g = objectArray[n2];
            ILink[] iLinkArray = ((LinkGroup)g).getLinks();
            int n3 = iLinkArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ILink l = iLinkArray[n4];
                l.dispose();
                ++n4;
            }
            ++n2;
        }
    }

    private Control createLinkGroup(Composite parent, String title, ILink[] links) {
        Composite group = null;
        if (StringUtility.isNullOrEmpty((String)title)) {
            group = new Composite(parent, 0);
        } else {
            group = new Group(parent, 64);
            ((Group)group).setText(title);
        }
        this.getToolkit().adapt(group);
        ILink[] iLinkArray = links;
        int n = links.length;
        int n2 = 0;
        while (n2 < n) {
            ILink link = iLinkArray[n2];
            this.createHyperlink(group, link);
            ++n2;
        }
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        group.setLayout((Layout)layout);
        return group;
    }

    private Control createHyperlink(Composite parent, ILink link) {
        ImageHyperlink field = this.getToolkit().createImageHyperlink(parent, 0);
        field.setUnderlined(true);
        field.setText(link.getName());
        field.setImage(link.getImage());
        field.addHyperlinkListener((IHyperlinkListener)new P_ExecuteLinkListener(link));
        GridData layoutData = new GridData(768);
        field.setLayoutData((Object)layoutData);
        return field;
    }

    public void setLinksProperty(LinksPresenterModel linksProperty) {
        if (this.getContainer() != null && !this.getContainer().isDisposed() && !CompareUtility.equals((Object)this.m_linksProperty, (Object)linksProperty)) {
            Control[] controlArray = this.getContainer().getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
            ILink[] globalLinks = linksProperty.getOrderdGlobalLinks();
            LinkGroup[] linkGroups = linksProperty.getOrderedNotEmtyGroups();
            if (globalLinks.length > 0) {
                Control globalGroup = this.createLinkGroup(this.getContainer(), null, globalLinks);
                GridData globData = new GridData(1808);
                globData.horizontalSpan = 2 - linkGroups.length % 2;
                globalGroup.setLayoutData((Object)globData);
            }
            LinkGroup[] linkGroupArray = linkGroups;
            int n3 = linkGroups.length;
            int n4 = 0;
            while (n4 < n3) {
                LinkGroup group = linkGroupArray[n4];
                Control uiGroup = this.createLinkGroup(this.getContainer(), group.getName(), group.getLinks());
                GridData formData = new GridData(1808);
                uiGroup.setLayoutData((Object)formData);
                ++n4;
            }
            this.m_linksProperty = linksProperty;
        }
    }

    public LinksPresenterModel getLinksProperty() {
        return this.m_linksProperty;
    }

    private class P_ExecuteLinkListener
    extends HyperlinkAdapter {
        private final ILink m_link;

        public P_ExecuteLinkListener(ILink link) {
            this.m_link = link;
        }

        public void linkActivated(HyperlinkEvent e) {
            this.m_link.execute();
        }
    }
}

