/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi;

import java.text.DecimalFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.presenter.multi.AbstractMultiValuePresenter;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodBean;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethodSet;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MultiIntegerPresenter
extends AbstractMultiValuePresenter<Integer> {
    public MultiIntegerPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[-+0-9\\'eEinf]*");
    }

    @Override
    protected void init(ConfigurationMethodSet methodSet) throws CoreException {
        super.init(methodSet);
        MethodBean<T>[] methodBeans = this.getMethodBeans();
        Integer[] ar = new Integer[methodBeans.length];
        int i = 0;
        while (i < methodBeans.length) {
            ar[i] = (Integer)methodBeans[i].getCurrentSourceValue();
            ++i;
        }
        if (!this.allEqual(ar)) {
            this.getTextComponent().setText("###");
        } else {
            this.getTextComponent().setText(this.formatDisplayValue(ar[0]));
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }

    @Override
    protected String formatSourceValue(Integer value) throws CoreException {
        if (value == null) {
            return "null";
        }
        if (value == Integer.MAX_VALUE) {
            return "Integer.MAX_VALUE";
        }
        if (value == -2147483647) {
            return "-Integer.MAX_VALUE";
        }
        return DecimalFormat.getNumberInstance().format(value);
    }

    @Override
    protected String formatDisplayValue(Integer value) throws CoreException {
        if (value == null) {
            return "";
        }
        if (value == Integer.MAX_VALUE) {
            return "inf";
        }
        if (value == -2147483647) {
            return "-inf";
        }
        return DecimalFormat.getNumberInstance().format(value);
    }

    @Override
    protected Integer parseSourceInput(String value, ConfigurationMethod method) throws CoreException {
        Integer d = PropertyMethodSourceUtilities.parseReturnParameterInteger((String)value, (IMethod)method.peekMethod(), (ITypeHierarchy)method.getSuperTypeHierarchy());
        return d;
    }

    @Override
    protected Integer parseDisplayInput(String input) throws CoreException {
        Integer d = PropertyMethodSourceUtilities.parseReturnParameterInteger((String)input);
        return d;
    }

    @Override
    protected synchronized void storeMethods(MethodBean<Integer>[] beans, Integer value) {
        ArrayList<Object> list = new ArrayList<Object>();
        MethodBean<Integer>[] methodBeanArray = beans;
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBean<Integer> bean = methodBeanArray[n2];
            try {
                String sourceValue = this.formatSourceValue(value);
                ConfigurationMethod method = bean.getMethod();
                if (ScoutSdkUtility.equals((Object)method.computeDefaultValue(), (Object)sourceValue)) {
                    if (method.isImplemented()) {
                        list.add(new ScoutMethodDeleteOperation(method.peekMethod()));
                    }
                } else {
                    list.add(new ConfigPropertyMethodUpdateOperation(method.getType(), method.getMethodName(), "return " + sourceValue + ";", true));
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("could not format source value", e);
            }
            ++n2;
        }
        new OperationJob(list).schedule();
    }

    private boolean allEqual(Integer[] ar) {
        if (ar.length > 0) {
            Integer ref = ar[0];
            Integer[] integerArray = ar;
            int n = ar.length;
            int n2 = 0;
            while (n2 < n) {
                Integer b = integerArray[n2];
                if (b == null && ref != null) {
                    return false;
                }
                if (b != null && ref == null) {
                    return false;
                }
                if (b != ref) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

