/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.ScoutStatus;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BooleanPresenter
extends AbstractMethodPresenter {
    private Button m_checkbox;
    private boolean m_defaultValue;

    public BooleanPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        Composite rootArea = this.getToolkit().createComposite(container);
        this.m_checkbox = this.getToolkit().createButton(rootArea, "", 32);
        this.m_checkbox.setEnabled(false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BooleanPresenter.this.handleCheckboxSelectionChanged();
            }
        };
        this.m_checkbox.addSelectionListener((SelectionListener)listener);
        RowLayout layout = new RowLayout();
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.spacing = 0;
        rootArea.setLayout((Layout)layout);
        return rootArea;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_checkbox.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_checkbox.getEnabled() && super.isEnabled();
        }
        return false;
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        super.init(method);
        this.m_defaultValue = Boolean.valueOf(this.getMethod().computeDefaultValue());
        try {
            this.parseMethodBody();
        }
        catch (JavaModelException e1) {
            ScoutSdkUi.logError("could not parse method body", e1);
        }
        this.m_checkbox.setEnabled(true);
    }

    protected void parseMethodBody() throws CoreException {
        Matcher m = Pattern.compile("\\{\\s*return\\s*(true|false)\\s*\\;\\s*\\}", 32).matcher(this.getMethod().getSource());
        if (!m.find()) {
            throw new CoreException((IStatus)new ScoutStatus(this.getMethod().getSource()));
        }
        this.m_checkbox.setSelection(Boolean.valueOf(m.group(1)).booleanValue());
    }

    private synchronized void handleCheckboxSelectionChanged() {
        ScoutMethodDeleteOperation op = null;
        String sourceValue = Boolean.toString(this.m_checkbox.getSelection());
        if (ScoutSdkUtility.equals((Object)this.getMethod().computeDefaultValue(), (Object)sourceValue)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + sourceValue + ";", false);
        }
        if (op != null) {
            OperationJob job = new OperationJob(op);
            job.setDebug(true);
            job.schedule();
        }
    }
}

