/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.ConstantFieldProposal;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormViewIdPresenter
extends AbstractProposalPresenter<ConstantFieldProposal<String>> {
    public FormViewIdPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        this.setProposals(ScoutProposalUtility.getFormViewIdTypeProposals());
        super.init(method);
    }

    @Override
    protected ConstantFieldProposal<String> parseInput(String input) throws CoreException {
        String parsedId = PropertyMethodSourceUtilities.parseReturnParameterString((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        return this.findProposal(parsedId);
    }

    @Override
    protected synchronized void storeValue(ConstantFieldProposal<String> value) {
        if (value == null) {
            value = (ConstantFieldProposal)this.getDefaultValue();
            this.getProposalComponent().acceptProposal(value);
        }
        ScoutMethodDeleteOperation op = null;
        if (ScoutSdkUtility.equals((Object)((ConstantFieldProposal)this.getDefaultValue()), (Object)value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            String sourceValue = value.getField().getElementName();
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + sourceValue + ";", false);
        }
        if (op != null) {
            new OperationJob(op).schedule();
        }
    }

    private ConstantFieldProposal<String> findProposal(String id) {
        ConstantFieldProposal[] constantFieldProposalArray = (ConstantFieldProposal[])this.getProposals();
        int n = constantFieldProposalArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConstantFieldProposal prop = constantFieldProposalArray[n2];
            if (((String)prop.getConstantValue()).equals(id)) {
                return prop;
            }
            ++n2;
        }
        return null;
    }
}

