/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.jdt.signature.IImportValidator;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.IconProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IconPresenter
extends AbstractProposalPresenter<IconProposal> {
    private Label m_currentIconPresenter;

    public IconPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        Composite rootPane = this.getToolkit().createComposite(container);
        this.m_currentIconPresenter = this.getToolkit().createLabel(rootPane, "", 0x800000);
        Control text = super.createContent(rootPane);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.horizontalSpacing = 0;
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.verticalSpacing = 0;
        rootPane.setLayout((Layout)gLayout);
        text.setLayoutData((Object)new GridData(768));
        GridData gData = new GridData(22, 22);
        gData.exclude = true;
        this.m_currentIconPresenter.setLayoutData((Object)gData);
        return rootPane;
    }

    @Override
    public void setCurrentSourceValue(IconProposal value) {
        super.setCurrentSourceValue(value);
        Image icon = null;
        if (value != null) {
            icon = value.getImage();
        }
        if (icon != null) {
            ((GridData)this.m_currentIconPresenter.getLayoutData()).exclude = false;
            this.m_currentIconPresenter.setVisible(true);
        } else {
            ((GridData)this.m_currentIconPresenter.getLayoutData()).exclude = true;
            this.m_currentIconPresenter.setVisible(false);
        }
        this.m_currentIconPresenter.setImage(icon);
        this.getContainer().layout(true, true);
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        IScoutBundle scoutBundle = SdkTypeUtility.getScoutBundle((IJavaElement)method.getType());
        this.setProposals(ScoutProposalUtility.getScoutIconProposals(ScoutSdkUi.getDisplay(), scoutBundle));
        super.init(method);
    }

    @Override
    protected IconProposal parseInput(String input) throws CoreException {
        String parsedString = PropertyMethodSourceUtilities.parseReturnParameterIcon((String)input, (IMethod)this.getMethod().peekMethod());
        IconProposal findProposal = this.findProposal(parsedString);
        return findProposal;
    }

    @Override
    protected synchronized void storeValue(final IconProposal value) {
        Object op = null;
        if (ScoutSdkUtility.equals((Object)((IconProposal)this.getDefaultValue()), (Object)value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), null, true){

                protected String createMethodBody(IMethod methodToOverride, IImportValidator validator) throws JavaModelException {
                    StringBuilder source = new StringBuilder();
                    source.append("return ");
                    if (value != null) {
                        String iconTypeSig = Signature.createTypeSignature((String)value.getImageDescription().getConstantField().getDeclaringType().getFullyQualifiedName(), (boolean)false);
                        source.append("  " + ScoutSdkUtility.getSimpleTypeRefName((String)iconTypeSig, (IImportValidator)validator) + "." + value.getImageDescription().getConstantField().getElementName());
                        source.append(";");
                    } else {
                        source.append("null;");
                    }
                    return source.toString();
                }
            };
        }
        if (op != null) {
            new OperationJob(op).schedule();
        }
    }

    private IconProposal findProposal(String value) {
        if (value != null) {
            String simpleIconName = value.replaceAll("^.*\\.([^\\.]+)$", "$1");
            IconProposal[] iconProposalArray = (IconProposal[])this.getProposals();
            int n = iconProposalArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconProposal prop = iconProposalArray[n2];
                if (prop.getImageDescription().getIconName().equals(simpleIconName)) {
                    return prop;
                }
                ++n2;
            }
        }
        return null;
    }
}

