/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.text.DecimalFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LongPresenter
extends AbstractValuePresenter<Long> {
    public LongPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[-+0-9\\'Eeinfl]*");
    }

    @Override
    protected String formatSourceValue(Long value) throws CoreException {
        if (value == null) {
            return "null";
        }
        if (value == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        if (value == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        String sourceVal = value.toString();
        return String.valueOf(sourceVal) + "L";
    }

    @Override
    protected String formatDisplayValue(Long value) throws CoreException {
        if (value == null) {
            return "";
        }
        if (value == Long.MAX_VALUE) {
            return "inf";
        }
        if (value == Long.MIN_VALUE) {
            return "-inf";
        }
        return DecimalFormat.getNumberInstance().format(value);
    }

    @Override
    protected Long parseSourceInput(String input) throws CoreException {
        return this.parseDisplayInput(input);
    }

    @Override
    protected Long parseDisplayInput(String input) throws CoreException {
        if (input == null || input.equals("")) {
            return null;
        }
        Long d = PropertyMethodSourceUtilities.parseReturnParameterLong((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        return d;
    }

    @Override
    protected synchronized void storeValue(Long value) throws CoreException {
        ScoutMethodDeleteOperation op = null;
        if (ScoutSdkUtility.equals((Object)((Long)this.getDefaultValue()), (Object)value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            String sourceValue = this.formatSourceValue(value);
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + sourceValue + ";", false);
        }
        if (op != null) {
            new OperationJob(op).schedule();
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }
}

