/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.action.NlsEntryNewAction;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.ScoutStatus;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.method.NlsTextMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalTextField;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.nls.NlsNewProposal;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.nls.NlsNullProposal;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractMethodPresenter;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NlsTextPresenter
extends AbstractMethodPresenter {
    private NlsProposalTextField m_proposalField;
    private INlsEntry m_currentSourceTuple;
    private INlsEntry m_defaultTuple;
    private INlsProject m_nlsProject;
    private OptimisticLock storeValueLock = new OptimisticLock();

    public NlsTextPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected Control createContent(Composite container) {
        this.m_proposalField = new NlsProposalTextField(container, null, NlsProposalTextField.TYPE_NO_LABEL);
        this.toolkitAdapt((Control)this.m_proposalField);
        this.m_proposalField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                NlsTextPresenter.this.handleProposalAccepted(event);
            }
        });
        this.m_proposalField.setEnabled(false);
        return this.m_proposalField;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.isDisposed()) {
            this.m_proposalField.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        if (!this.isDisposed()) {
            return this.m_proposalField.getEnabled() && super.isEnabled();
        }
        return false;
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        if (method == null) {
            return;
        }
        super.init(method);
        this.setNlsProject(SdkTypeUtility.findNlsProject((IJavaElement)method.getType()));
        this.m_proposalField.setNlsProject(this.getNlsProject());
        if (this.getNlsProject() == null) {
            this.m_proposalField.setEnabled(false);
            return;
        }
        String defaultKey = PropertyMethodSourceUtilities.parseReturnParameterNlsKey((String)this.getMethod().computeDefaultValue());
        if (defaultKey != null) {
            this.m_defaultTuple = this.getNlsProject().getEntry(defaultKey);
        }
        String currentSourceValueKey = PropertyMethodSourceUtilities.parseReturnParameterNlsKey((String)this.getMethod().computeValue());
        try {
            this.storeValueLock.acquire();
            if (currentSourceValueKey != null) {
                this.m_currentSourceTuple = this.getNlsProject().getEntry(currentSourceValueKey);
                if (this.m_currentSourceTuple == null) {
                    throw new CoreException((IStatus)new ScoutStatus("could not parse nls presenter of : " + this.getMethod().getMethodName()));
                }
                this.m_proposalField.acceptProposal(new NlsProposal(this.m_currentSourceTuple, this.getNlsProject().getDevelopmentLanguage()));
            } else {
                this.m_proposalField.acceptProposal(null);
            }
            this.m_proposalField.setEnabled(true);
        }
        finally {
            this.storeValueLock.release();
        }
    }

    protected void handleProposalAccepted(ContentProposalEvent event) {
        IContentProposalEx proposal = event.proposal;
        if (proposal == null) {
            this.m_proposalField.setText("");
            this.storeNlsText(null);
        } else if (proposal instanceof NlsNewProposal) {
            String proposalFieldText = event.text.substring(0, event.cursorPosition);
            String key = this.getNewKey(proposalFieldText);
            NlsEntry row = new NlsEntry(key, this.getNlsProject());
            row.addTranslation(this.getNlsProject().getDevelopmentLanguage(), proposalFieldText);
            NlsEntryNewAction action = new NlsEntryNewAction(row, true, this.getNlsProject());
            action.run();
            try {
                action.join();
            }
            catch (InterruptedException e) {
                ScoutSdkUi.logWarning(e);
            }
            row = action.getEntry();
            if (row != null) {
                NlsProposal newProposal = new NlsProposal((INlsEntry)row, this.getNlsProject().getDevelopmentLanguage());
                this.m_proposalField.acceptProposal(newProposal);
                this.storeNlsText(newProposal);
            } else {
                this.storeNlsText(null);
                this.m_proposalField.setText("");
            }
        } else if (proposal instanceof NlsNullProposal) {
            this.storeNlsText(null);
        } else if (proposal instanceof NlsProposal) {
            this.storeNlsText((NlsProposal)proposal);
        }
    }

    protected String getNewKey(String value) {
        List<String> existingKeys = Arrays.asList(this.getNlsProject().getAllKeys());
        if (value == null || value.length() == 0) {
            return null;
        }
        String[] split = value.split(" ");
        value = "";
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String splitValue = stringArray[n2];
            value = String.valueOf(value) + Character.toUpperCase(splitValue.charAt(0)) + (splitValue.length() > 1 ? splitValue.substring(1) : "");
            ++n2;
        }
        String newKey = value;
        int i = 0;
        while (existingKeys.contains(newKey)) {
            newKey = String.valueOf(value) + i++;
        }
        return newKey;
    }

    protected synchronized void storeNlsText(NlsProposal proposal) {
        try {
            if (this.storeValueLock.acquire()) {
                ScoutMethodDeleteOperation op = null;
                if (ScoutSdkUtility.equals((Object)this.m_defaultTuple, (Object)proposal)) {
                    if (this.getMethod().isImplemented()) {
                        op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
                    }
                } else {
                    op = new NlsTextMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), false);
                    if (proposal != null) {
                        ((NlsTextMethodUpdateOperation)op).setNlsEntry(proposal.getNlsEntry());
                    }
                }
                if (op != null) {
                    new OperationJob(op).schedule();
                }
            }
        }
        finally {
            this.storeValueLock.release();
        }
    }

    public void setNlsProject(INlsProject nlsProject) {
        this.m_nlsProject = nlsProject;
    }

    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }
}

