/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.PrimitiveTypeProposal;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractProposalPresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PrimitiveTypePresenter
extends AbstractProposalPresenter<PrimitiveTypeProposal> {
    private static final Class<?>[] PRIMITIVE_TYPES = new Class[]{String.class, Double.class, Float.class, Long.class, Integer.class, Short.class, Date.class, Byte.class};

    public PrimitiveTypePresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent);
    }

    @Override
    protected void init(ConfigurationMethod method) throws CoreException {
        IContentProposalEx[] proposals = new PrimitiveTypeProposal[PRIMITIVE_TYPES.length];
        int i = 0;
        while (i < proposals.length) {
            proposals[i] = new PrimitiveTypeProposal(ScoutSdkUi.getImage("default.gif"), ScoutSdk.getType((String)PRIMITIVE_TYPES[i].getName()));
            ++i;
        }
        this.setProposals(proposals);
        super.init(method);
    }

    @Override
    protected PrimitiveTypeProposal parseInput(String input) throws CoreException {
        IType referedType = PropertyMethodSourceUtilities.parseReturnParameterClass((String)input, (IMethod)this.getMethod().peekMethod());
        return this.findProposal(referedType);
    }

    private PrimitiveTypeProposal findProposal(IType referedType) {
        PrimitiveTypeProposal[] primitiveTypeProposalArray = (PrimitiveTypeProposal[])this.getProposals();
        int n = primitiveTypeProposalArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrimitiveTypeProposal prop = primitiveTypeProposalArray[n2];
            if (CompareUtility.equals((Object)prop.getPrimitiveType(), (Object)referedType)) {
                return prop;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected synchronized void storeValue(PrimitiveTypeProposal value) {
        ScoutMethodDeleteOperation op = null;
        if (ScoutSdkUtility.equals((Object)((PrimitiveTypeProposal)this.getDefaultValue()), (Object)value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            String sourceValue = String.valueOf(value.getPrimitiveType().getElementName()) + ".class";
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + sourceValue + ";", false);
        }
        if (op != null) {
            new OperationJob(op).schedule();
        }
    }
}

