/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.ConfigPropertyMethodUpdateOperation;
import org.eclipse.scout.sdk.operation.method.ScoutMethodDeleteOperation;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class StringPresenter
extends AbstractValuePresenter<String> {
    public StringPresenter(FormToolkit toolkit, Composite parent) {
        super(toolkit, parent, null);
    }

    @Override
    protected String formatSourceValue(String value) throws CoreException {
        return "\"" + value + "\"";
    }

    @Override
    protected String formatDisplayValue(String value) throws CoreException {
        return value;
    }

    @Override
    protected String parseSourceInput(String input) throws CoreException {
        String value = PropertyMethodSourceUtilities.parseReturnParameterString((String)input, (IMethod)this.getMethod().peekMethod(), (ITypeHierarchy)this.getMethod().getSuperTypeHierarchy());
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    protected String parseDisplayInput(String input) throws CoreException {
        return input;
    }

    @Override
    protected synchronized void storeValue(String value) throws CoreException {
        ScoutMethodDeleteOperation op = null;
        if (ScoutSdkUtility.equals((Object)((String)this.getDefaultValue()), (Object)value)) {
            if (this.getMethod().isImplemented()) {
                op = new ScoutMethodDeleteOperation(this.getMethod().peekMethod());
            }
        } else {
            String sourceValue = this.formatSourceValue(value);
            op = new ConfigPropertyMethodUpdateOperation(this.getMethod().getType(), this.getMethod().getMethodName(), "  return " + sourceValue + ";", false);
        }
        if (op != null) {
            new OperationJob(op).schedule();
        }
    }
}

