/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.WizardPageFieldToolkit;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractWizardPage
extends WizardPage {
    private IStatus m_status = Status.OK_STATUS;
    private IStatus m_defaultOkStatus = Status.OK_STATUS;
    private Composite m_content;
    private final WizardPageFieldToolkit m_fieldToolkit = new WizardPageFieldToolkit();
    private int m_stateChangingCounter = 0;
    private boolean m_excludePage;
    private ArrayList<IStatusProvider> m_statusProvider = new ArrayList();

    public AbstractWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public AbstractWizardPage(String pageName) {
        this(pageName, null, null);
    }

    public WizardPageFieldToolkit getFieldToolkit() {
        return this.m_fieldToolkit;
    }

    public void setDefaultMessage(String newMessage) {
        this.m_defaultOkStatus = new Status(0, "org.eclipse.scout.sdk", newMessage);
        this.setStatus(this.m_status);
    }

    public void postActivate() {
    }

    public final void createControl(Composite parent) {
        this.m_content = new Composite(parent, 0);
        this.m_content.setLayout((Layout)new FillLayout());
        this.createContent(this.m_content);
        this.setControl((Control)this.m_content);
        this.revalidate();
    }

    protected boolean isControlCreated() {
        return super.isControlCreated() && !this.getControl().isDisposed();
    }

    protected abstract void createContent(Composite var1);

    public Composite getControl() {
        return this.m_content;
    }

    public void setVisible(boolean visible) {
        this.m_content.setVisible(visible);
    }

    public boolean addStatusProvider(IStatusProvider provider) {
        return this.m_statusProvider.add(provider);
    }

    public boolean removeStatusProvider(IStatusProvider provider) {
        return this.m_statusProvider.remove(provider);
    }

    protected void setStatus(IStatus status) {
        if (status == null) {
            this.setPageComplete(true);
        } else {
            this.m_status = status.isOK() && Status.OK_STATUS.equals(status) ? this.m_defaultOkStatus : status;
            if (!this.m_status.matches(4)) {
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        }
        if (this.isCurrentPage()) {
            this.displayStatus(this.getStatus(), this.m_defaultOkStatus);
        }
    }

    protected void displayStatus(IStatus status, IStatus defaultStatus) {
        if (status == defaultStatus) {
            this.setMessage(this.getDescription(), 0);
        } else {
            int messagetype;
            IStatus highestSeverityStatus = this.getHighestSeverityStatus(status, defaultStatus);
            switch (highestSeverityStatus.getSeverity()) {
                case 1: {
                    messagetype = 1;
                    break;
                }
                case 2: {
                    messagetype = 2;
                    break;
                }
                case 4: {
                    messagetype = 3;
                    break;
                }
                default: {
                    messagetype = 0;
                }
            }
            String message = highestSeverityStatus.getMessage();
            this.setMessage(message, messagetype);
        }
    }

    private IStatus getHighestSeverityStatus(IStatus status, IStatus highestSeverity) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                highestSeverity = this.getHighestSeverityStatus(child, highestSeverity);
                ++n2;
            }
            return highestSeverity;
        }
        if (highestSeverity.getSeverity() < status.getSeverity()) {
            highestSeverity = status;
        }
        return highestSeverity;
    }

    public void pingStateChanging() {
        if (this.m_stateChangingCounter <= 0) {
            this.m_stateChangingCounter = 0;
            this.revalidate();
        }
    }

    protected void setStateChanging(boolean changing) {
        this.m_stateChangingCounter = changing ? ++this.m_stateChangingCounter : --this.m_stateChangingCounter;
        if (this.m_stateChangingCounter <= 0) {
            this.m_stateChangingCounter = 0;
            this.revalidate();
        }
    }

    protected final void revalidate() {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.scout.sdk", -1, "multi status", null);
        this.validatePage(multiStatus);
        for (IStatusProvider p : this.m_statusProvider) {
            p.validate((Object)this, multiStatus);
        }
        this.setStatus((IStatus)multiStatus);
    }

    protected void validatePage(MultiStatus multiStatus) {
    }

    public boolean performFinish() {
        return true;
    }

    protected IStatus getStatus() {
        return this.m_status;
    }

    public IStatus getDefaultOkStatus() {
        return this.m_defaultOkStatus;
    }

    public void setExcludePage(boolean excludePage) {
        this.m_excludePage = excludePage;
    }

    public boolean isExcludePage() {
        return this.m_excludePage;
    }
}

