/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.export.ExportServerWarOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.FileSelectionField;
import org.eclipse.scout.sdk.ui.fields.IFileSelectionListener;
import org.eclipse.scout.sdk.ui.fields.IFolderSelectedListener;
import org.eclipse.scout.sdk.ui.fields.IProductSelectionListener;
import org.eclipse.scout.sdk.ui.fields.ProductSelectionField;
import org.eclipse.scout.sdk.ui.fields.ResourceServletFolderSelectionField;
import org.eclipse.scout.sdk.ui.fields.ResourceServletFolderTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ExportServerWarWizardPage
extends AbstractWorkspaceWizardPage {
    private final String SETTINGS_WAR_FILE = "warFile";
    private final String SETTINGS_WAR_FILE_NAME = "warFileName";
    private final String SETTINGS_OVERWRITE_WAR = "warOverwrite";
    private final String SETTINGS_INCLUDE_CLIENT = "includeClientExport";
    private final String SETTINGS_CLIENT_PRODUCT = "clientProduct";
    static final String PROP_PRODUCT_FILE_SERVER = "serverProductFile";
    static final String PROP_PRODUCT_FILE_CLIENT = "clientProductFile";
    static final String PROP_WAR_FILE = "warFile";
    static final String PROP_OVERWRITE_EXISTING_WAR = "overwriteExistingWar";
    static final String PROP_INCLUDE_CLIENT_APPLICATION = "includeClientApplication";
    static final String PROP_CLIENT_EXPORT_FOLDER = "clientExportFolder";
    private final IScoutProject m_scoutProject;
    private FileSelectionField m_warFileField;
    private ProductSelectionField m_serverProductField;
    private Button m_overwriteButton;
    private ProductSelectionField m_clientProductField;
    private ResourceServletFolderSelectionField m_resourceFolderField;
    private IStatus m_serverProductStatus = Status.OK_STATUS;
    private IStatus m_clientProductStatus = Status.OK_STATUS;
    private IStatus m_clientExportFolderStatus = Status.OK_STATUS;
    private Button m_includeClientButton;

    public ExportServerWarWizardPage(IScoutProject scoutProject) {
        super(ExportServerWarWizardPage.class.getName());
        this.m_scoutProject = scoutProject;
        this.setTitle("Export war file.");
        this.setDefaultMessage("To export a product as a war file.\nThe export can be done directly into the webapps folder of a web server.");
    }

    @Override
    protected void createContent(Composite parent) {
        ITreeNode serverProductTreeRoot = TreeUtility.createProductTree(this.getScoutProject(), new P_ServerProductFilter(), false);
        this.m_serverProductField = new ProductSelectionField(parent, serverProductTreeRoot);
        this.m_serverProductField.setLabelText("Product file");
        this.m_serverProductField.addProductSelectionListener(new IProductSelectionListener(){

            @Override
            public void productSelected(IFile productFile) {
                ExportServerWarWizardPage.this.setServerProductFileInternal(productFile);
                ExportServerWarWizardPage.this.pingStateChanging();
            }
        });
        ITreeNode[] serverProductNodes = TreeUtility.findNodes(serverProductTreeRoot, NodeFilters.getByType(2999));
        if (serverProductNodes.length == 1) {
            IFile pf = (IFile)serverProductNodes[0].getData();
            this.setServerProductFileInternal(pf);
            this.m_serverProductField.setProductFile(pf);
        } else if (serverProductNodes.length == 0) {
            this.m_serverProductStatus = new Status(4, "org.eclipse.scout.sdk.ui", "No server product to deploy on a webserver available.\nA deployable server product must contain the bundles:\n- " + ScoutSdkUtility.BUNDLE_ID_HTTP_SERVLETBRIDGE + "- " + ScoutSdkUtility.BUNDLE_ID_HTTP_REGISTRY);
        }
        this.m_warFileField = new FileSelectionField(parent);
        this.m_warFileField.setLabelText("war file");
        this.m_warFileField.setFilterExtensions(new String[]{"*.war"});
        this.m_warFileField.setFileName(this.findBestFitWarName());
        String warFile = this.getDialogSettings().get(PROP_WAR_FILE);
        if (!StringUtility.isNullOrEmpty((String)warFile)) {
            this.setWarFileInternal(new File(warFile));
            this.m_warFileField.setFile(this.getWarFile());
        }
        this.m_warFileField.addProductSelectionListener(new IFileSelectionListener(){

            @Override
            public void fileSelected(File file) {
                String fileName = "";
                if (file != null) {
                    fileName = file.getAbsolutePath();
                }
                ExportServerWarWizardPage.this.getDialogSettings().put(ExportServerWarWizardPage.PROP_WAR_FILE, fileName);
                ExportServerWarWizardPage.this.setWarFileInternal(file);
                ExportServerWarWizardPage.this.pingStateChanging();
            }
        });
        this.m_overwriteButton = new Button(parent, 32);
        this.m_overwriteButton.setText("Overwrite existing war file");
        boolean initialSelection = this.getDialogSettings().getBoolean("warOverwrite");
        this.setOverwriteExistingWarFileInternal(initialSelection);
        this.m_overwriteButton.setSelection(initialSelection);
        this.m_overwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportServerWarWizardPage.this.getDialogSettings().put("warOverwrite", ExportServerWarWizardPage.this.m_overwriteButton.getSelection());
                ExportServerWarWizardPage.this.setOverwriteExistingWarFileInternal(ExportServerWarWizardPage.this.m_overwriteButton.getSelection());
                ExportServerWarWizardPage.this.pingStateChanging();
            }
        });
        Control includeClientGroup = this.createIncludeClientBox(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_serverProductField.setLayoutData(new GridData(768));
        this.m_warFileField.setLayoutData(new GridData(768));
        this.m_overwriteButton.setLayoutData((Object)new GridData(768));
        includeClientGroup.setLayoutData((Object)new GridData(1808));
    }

    protected Control createIncludeClientBox(Composite parent) {
        IFile productFile;
        IProject project;
        Path p;
        Group group = new Group(parent, 16);
        Label description = new Label((Composite)group, 64);
        description.setText("If a client application is indluded it will be available for download under the rootUrl/download.");
        this.m_includeClientButton = new Button((Composite)group, 32);
        this.m_includeClientButton.setText("Include Client application");
        boolean initialSelection = this.getDialogSettings().getBoolean("includeClientExport");
        this.setIncludingClientInternal(initialSelection);
        this.m_includeClientButton.setSelection(initialSelection);
        this.m_includeClientButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportServerWarWizardPage.this.getDialogSettings().put("includeClientExport", ExportServerWarWizardPage.this.m_includeClientButton.getSelection());
                ExportServerWarWizardPage.this.setIncludingClientInternal(ExportServerWarWizardPage.this.m_includeClientButton.getSelection());
                ExportServerWarWizardPage.this.m_clientProductField.setEnabled(ExportServerWarWizardPage.this.m_includeClientButton.getSelection());
                ExportServerWarWizardPage.this.pingStateChanging();
            }
        });
        ITreeNode clientProductTreeRoot = TreeUtility.createProductTree(this.getScoutProject(), new P_ClientProductFilter(), false);
        this.m_clientProductField = new ProductSelectionField((Composite)group, clientProductTreeRoot);
        this.m_clientProductField.setLabelText("Client product to include");
        String clientProductFileName = this.getDialogSettings().get("clientProduct");
        if (!StringUtility.isNullOrEmpty((String)clientProductFileName) && (p = new Path(clientProductFileName)).segmentCount() > 1 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(p.segment(0))) != null && (productFile = project.getFile(p.removeFirstSegments(1))) != null) {
            this.m_clientProductField.setProductFile(productFile);
            this.setClientProductFileInternal(productFile);
        }
        this.m_clientProductField.addProductSelectionListener(new IProductSelectionListener(){

            @Override
            public void productSelected(IFile productFile) {
                String productFileName = null;
                if (productFile != null) {
                    productFileName = String.valueOf(productFile.getProject().getName()) + "/" + productFile.getProjectRelativePath().toPortableString();
                }
                ExportServerWarWizardPage.this.getDialogSettings().put("clientProduct", productFileName);
                ExportServerWarWizardPage.this.setClientProductFileInternal(productFile);
                ExportServerWarWizardPage.this.pingStateChanging();
            }
        });
        ITreeNode[] clientProductNodes = TreeUtility.findNodes(clientProductTreeRoot, NodeFilters.getByType(2999));
        if (clientProductNodes.length == 1) {
            IFile pf = (IFile)clientProductNodes[0].getData();
            this.setClientProductFileInternal(pf);
            this.m_clientProductField.setProductFile(pf);
        } else if (clientProductNodes.length == 0) {
            this.m_clientProductStatus = new Status(4, "org.eclipse.scout.sdk.ui", "No client product to add as download available.");
        }
        this.m_resourceFolderField = new ResourceServletFolderSelectionField((Composite)group, this.getScoutProject());
        this.m_resourceFolderField.setLabelText("Client download location");
        this.m_resourceFolderField.addProductSelectionListener(new IFolderSelectedListener(){

            @Override
            public void handleFolderSelection(IFolder folder) {
                ExportServerWarWizardPage.this.setClientExportFolderInternal(folder);
                ExportServerWarWizardPage.this.pingStateChanging();
            }
        });
        ITreeNode[] folderNodes = TreeUtility.findNodes(this.m_resourceFolderField.getRootNode(), NodeFilters.getByType(ResourceServletFolderTree.NODE_TYPE_FOLDER));
        if (folderNodes.length == 1) {
            IFolder folder = (IFolder)folderNodes[0].getData();
            this.setClientExportFolderInternal(folder);
            this.m_resourceFolderField.setFolder(folder);
        } else if (folderNodes.length == 0) {
            this.m_clientExportFolderStatus = new Status(4, "org.eclipse.scout.sdk.ui", "Could not find a ResourceServlet registration.\nEnsure to register a ResourceServlet with the two parameters [bundle-name, bundle-path].");
        }
        group.setLayout((Layout)new GridLayout(1, true));
        description.setLayoutData((Object)new GridData(768));
        this.m_includeClientButton.setLayoutData((Object)new GridData(768));
        this.m_clientProductField.setLayoutData(new GridData(768));
        this.m_resourceFolderField.setLayoutData(new GridData(768));
        return group;
    }

    public IScoutProject getScoutProject() {
        return this.m_scoutProject;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager manager) throws CoreException {
        ExportServerWarOperation op = new ExportServerWarOperation(this.getServerProductFile());
        op.setWarFileName(this.getWarFile().getAbsolutePath());
        if (this.getClientProductFile() != null && this.isIncludingClient()) {
            op.setClientProduct(this.getClientProductFile());
            op.setHtmlFolder(this.getClientExportFolder());
        }
        OperationJob job = new OperationJob((IOperation)op);
        job.schedule();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusServerProductField());
            multiStatus.add(this.getStatusWarField());
            multiStatus.add(this.getStatusOverwriteWarField());
            multiStatus.add(this.getStatusClientProductField());
            multiStatus.add(this.getStatusClientExportFolder());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusServerProductField() throws JavaModelException {
        if (this.getServerProductFile() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "No server product file specified!");
        }
        return this.m_serverProductStatus;
    }

    protected IStatus getStatusClientProductField() throws JavaModelException {
        if (this.isIncludingClient()) {
            if (this.m_clientProductStatus.isOK() && this.getClientProductFile() == null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "No client product file specified!");
            }
            return this.m_clientProductStatus;
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusWarField() throws JavaModelException {
        if (this.getWarFile() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "No war file specified!");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusOverwriteWarField() throws JavaModelException {
        if (!this.isOverwriteExistingWarFile() && this.getWarFile() != null && this.getWarFile().exists()) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "war file already exists!");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusClientExportFolder() throws JavaModelException {
        if (this.isIncludingClient()) {
            if (this.m_clientExportFolderStatus.isOK() && this.getClientExportFolder() == null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "No client export location specified!");
            }
            return this.m_clientExportFolderStatus;
        }
        return Status.OK_STATUS;
    }

    public IFile getServerProductFile() {
        return (IFile)this.getProperty(PROP_PRODUCT_FILE_SERVER);
    }

    public void setServerProductFile(IFile productFile) {
        try {
            this.setStateChanging(true);
            this.setServerProductFileInternal(productFile);
            if (this.isControlCreated()) {
                this.m_serverProductField.setProductFile(productFile);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setServerProductFileInternal(IFile productFile) {
        this.setProperty(PROP_PRODUCT_FILE_SERVER, productFile);
    }

    public IFile getClientProductFile() {
        return (IFile)this.getProperty(PROP_PRODUCT_FILE_CLIENT);
    }

    public void setClientProductFile(IFile productFile) {
        try {
            this.setStateChanging(true);
            this.setClientProductFileInternal(productFile);
            if (this.isControlCreated()) {
                this.m_clientProductField.setProductFile(productFile);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setClientProductFileInternal(IFile productFile) {
        this.setProperty(PROP_PRODUCT_FILE_CLIENT, productFile);
    }

    public File getWarFile() {
        return (File)this.getProperty(PROP_WAR_FILE);
    }

    public void setWarFile(File warFile) {
        try {
            this.setStateChanging(true);
            this.setWarFileInternal(warFile);
            if (this.isControlCreated()) {
                this.m_warFileField.setFile(warFile);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setWarFileInternal(File warFile) {
        this.setProperty(PROP_WAR_FILE, warFile);
    }

    public boolean isOverwriteExistingWarFile() {
        return this.getPropertyBool(PROP_OVERWRITE_EXISTING_WAR);
    }

    public void setOverwriteExistingWarFile(boolean overwriteExistingWarFile) {
        try {
            this.setStateChanging(true);
            this.setOverwriteExistingWarFileInternal(overwriteExistingWarFile);
            if (this.isControlCreated()) {
                this.m_overwriteButton.setSelection(overwriteExistingWarFile);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setOverwriteExistingWarFileInternal(boolean overwriteExistingWarFile) {
        this.setPropertyBool(PROP_OVERWRITE_EXISTING_WAR, overwriteExistingWarFile);
    }

    public boolean isIncludingClient() {
        return this.getPropertyBool(PROP_INCLUDE_CLIENT_APPLICATION);
    }

    public void setIncludingClient(boolean includingClient) {
        try {
            this.setStateChanging(true);
            this.setIncludingClientInternal(includingClient);
            if (this.isControlCreated()) {
                this.m_includeClientButton.setSelection(includingClient);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setIncludingClientInternal(boolean includingClient) {
        this.setPropertyBool(PROP_INCLUDE_CLIENT_APPLICATION, includingClient);
    }

    public IFolder getClientExportFolder() {
        return (IFolder)this.getProperty(PROP_CLIENT_EXPORT_FOLDER);
    }

    public void setClientExportFolder(IFolder folder) {
        try {
            this.setStateChanging(true);
            this.setClientExportFolderInternal(folder);
            if (this.isControlCreated()) {
                this.m_resourceFolderField.setFolder(folder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setClientExportFolderInternal(IFolder folder) {
        this.setProperty(PROP_CLIENT_EXPORT_FOLDER, folder);
    }

    private String findBestFitWarName() {
        String warName = null;
        if (this.getScoutProject().getUiSwingBundle() != null) {
            warName = this.findNameInBundle(this.getScoutProject().getUiSwingBundle());
        }
        if (warName == null && this.getScoutProject().getUiSwtBundle() != null) {
            warName = this.findNameInBundle(this.getScoutProject().getUiSwtBundle());
        }
        return warName;
    }

    private String findNameInBundle(IScoutBundle bundle) {
        block2: {
            P_ConfigIniVisitor visitor = new P_ConfigIniVisitor();
            try {
                bundle.getProject().accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                if (!e.getStatus().isOK()) break block2;
                return visitor.getName();
            }
        }
        return null;
    }

    private class P_ClientProductFilter
    implements ITreeNodeFilter {
        private P_ClientProductFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 6: 
                case 7: 
                case 2999: {
                    return true;
                }
            }
            return false;
        }
    }

    private class P_ConfigIniVisitor
    implements IResourceVisitor {
        private Pattern m_serverUrlPattern = Pattern.compile("\\/([^\\/]*)\\/process");
        private String m_name;

        private P_ConfigIniVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && CompareUtility.equals((Object)"config.ini", (Object)resource.getName()) && resource.exists()) {
                this.parseConfigIniFile((IFile)resource);
            }
            return true;
        }

        private void parseConfigIniFile(IFile configIniFile) throws CoreException {
            block16: {
                Properties props = new Properties();
                InputStream is = null;
                try {
                    try {
                        is = configIniFile.getContents();
                        props.load(is);
                        String serverUrl = props.getProperty("server.url");
                        if (!StringUtility.isNullOrEmpty((String)serverUrl)) {
                            Matcher m = this.m_serverUrlPattern.matcher(serverUrl);
                            if (m.find()) {
                                this.m_name = m.group(1);
                            }
                            throw new CoreException(Status.OK_STATUS);
                        }
                    }
                    catch (IOException e) {
                        ScoutSdkUi.logError("cuold not parse file '" + configIniFile.getFullPath() + "'.", e);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        public String getName() {
            return this.m_name;
        }
    }

    private class P_ServerProductFilter
    implements ITreeNodeFilter {
        private P_ServerProductFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 5: {
                    return true;
                }
                case 2999: {
                    return ScoutSdkUtility.getServletBridgeProductStatus((IFile)((IFile)node.getData())).isOK();
                }
            }
            return false;
        }
    }
}

