/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newproject;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.project.NewBsiCaseGroupStep1Operation;
import org.eclipse.scout.sdk.operation.project.NewScoutProjectStep2Operation;
import org.eclipse.scout.sdk.operation.project.template.IScoutProjectTemplateOperation;
import org.eclipse.scout.sdk.operation.template.ITemplateVariableSet;
import org.eclipse.scout.sdk.operation.template.TemplateVariableSet;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.IScoutConstants;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizardPage;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectTemplateWizardPage;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.properties.part.singlepage.ScoutProjectPropertyPart;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class ScoutProjectNewWizard
extends Wizard
implements INewWizard {
    private ScoutProjectNewWizardPage m_page1;
    private ScoutProjectTemplateWizardPage m_page2;

    public ScoutProjectNewWizard() {
        this.setWindowTitle("New Scout Project");
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.m_page1 = new ScoutProjectNewWizardPage();
        this.addPage((IWizardPage)this.m_page1);
        this.m_page2 = new ScoutProjectTemplateWizardPage();
        this.addPage((IWizardPage)this.m_page2);
    }

    public final boolean performFinish() {
        new P_PerformFinishJob(this.getContainer().getShell().getDisplay()).schedule();
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) {
        try {
            this.m_page1.performFinish(monitor, workingCopyManager);
            return true;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not create scout project.", e);
            return false;
        }
    }

    public boolean canFinish() {
        return this.m_page1.isPageComplete();
    }

    private class P_ApplyTemplateOperation
    implements IOperation {
        private final IScoutProjectTemplateOperation m_template;

        public P_ApplyTemplateOperation(IScoutProjectTemplateOperation template) {
            this.m_template = template;
        }

        public String getOperationName() {
            return null;
        }

        public void validate() throws IllegalArgumentException {
        }

        public void run(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
            this.m_template.run(monitor, workingCopyManager);
        }
    }

    private class P_CreateProjectOperation
    implements IOperation {
        private IProject m_sharedProject;

        private P_CreateProjectOperation() {
        }

        public String getOperationName() {
            return "Create projects...";
        }

        public void validate() throws IllegalArgumentException {
        }

        public void run(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
            TemplateVariableSet variables = TemplateVariableSet.createNew((String)ScoutProjectNewWizard.this.m_page1.getProjectName(), (String)ScoutProjectNewWizard.this.m_page1.getPostFix(), (String)ScoutProjectNewWizard.this.m_page1.getProjectAlias());
            NewBsiCaseGroupStep1Operation op1 = new NewBsiCaseGroupStep1Operation(variables);
            op1.setCreateUiSwing(ScoutProjectNewWizard.this.m_page1.isCreateUiSwing());
            op1.setCreateUiSwt(ScoutProjectNewWizard.this.m_page1.isCreateUiSwt());
            op1.setCreateClient(ScoutProjectNewWizard.this.m_page1.isCreateClient());
            op1.setCreateShared(ScoutProjectNewWizard.this.m_page1.isCreateShared());
            op1.setCreateServer(ScoutProjectNewWizard.this.m_page1.isCreateServer());
            op1.setProjectName(ScoutProjectNewWizard.this.m_page1.getProjectName());
            op1.setProjectNamePostfix(ScoutProjectNewWizard.this.m_page1.getPostFix());
            op1.setProjectAlias(ScoutProjectNewWizard.this.m_page1.getProjectAlias());
            op1.validate();
            op1.run(monitor, workingCopyManager);
            this.m_sharedProject = op1.getSharedProject();
            NewScoutProjectStep2Operation op2 = new NewScoutProjectStep2Operation(op1, (ITemplateVariableSet)variables);
            op2.validate();
            op2.run(monitor, workingCopyManager);
        }

        public IProject getSharedProject() {
            return this.m_sharedProject;
        }
    }

    private class P_PerformFinishJob
    extends Job {
        private final Display m_display;

        public P_PerformFinishJob(Display display) {
            super("Create new Scout project...");
            this.m_display = display;
        }

        protected IStatus run(IProgressMonitor monitor) {
            P_CreateProjectOperation createProjectOperation = new P_CreateProjectOperation();
            OperationJob createProjectJob = new OperationJob((IOperation)createProjectOperation);
            if (this.scheduleAndWait(createProjectJob, 0L)) {
                IScoutProject[] pr;
                IScoutProjectTemplateOperation template = ScoutProjectNewWizard.this.m_page2.getSelectedTemplate();
                if (template != null) {
                    try {
                        Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, monitor);
                        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
                    }
                    catch (Exception exception) {
                        ScoutSdkUi.logError("error during waiting for auto build and refresh");
                    }
                    IProject shared = createProjectOperation.getSharedProject();
                    if (shared != null) {
                        template.setScoutProject(ScoutSdk.getScoutWorkspace().getScoutBundle(shared).getScoutProject());
                        OperationJob applyTemplateJob = new OperationJob((IOperation)new P_ApplyTemplateOperation(template));
                        this.scheduleAndWait(applyTemplateJob, 0L);
                    }
                }
                if ((pr = ScoutSdk.getScoutWorkspace().getRootProjects()).length > 0) {
                    IScoutProject sp = pr[0];
                    IFile[] products = TreeUtility.getAllProductFiles(sp);
                    ArrayList<IFile> dev = new ArrayList<IFile>(products.length);
                    IFile[] iFileArray = products;
                    int n = products.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile f = iFileArray[n2];
                        if (f.getFullPath().toString().toLowerCase().contains("development")) {
                            dev.add(f);
                        }
                        ++n2;
                    }
                    ScoutProjectPropertyPart.saveProductLaunchers(sp, dev.toArray(new IFile[dev.size()]));
                }
                this.m_display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)new P_ScoutPerspectiveConfigElement());
                        IScoutExplorerPart ex = ScoutSdkUi.getExplorer(true);
                        if (ex != null) {
                            ex.expandAndSelectProjectLevel();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }

        public boolean scheduleAndWait(OperationJob job, long delay) {
            job.schedule(delay);
            try {
                job.join();
                return job.getResult().isOK();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    private class P_ScoutPerspectiveConfigElement
    implements IConfigurationElement {
        private P_ScoutPerspectiveConfigElement() {
        }

        public String getAttribute(String name) throws InvalidRegistryObjectException {
            if (name.equals("finalPerspective")) {
                return IScoutConstants.SCOUT_PERSPECTIVE_ID;
            }
            if (name.equals("preferredPerspectives")) {
                return IScoutConstants.SCOUT_PERSPECTIVE_ID;
            }
            return null;
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            return null;
        }

        public String getAttribute(String attrName, String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue(String locale) throws InvalidRegistryObjectException {
            return null;
        }

        public String getAttributeAsIs(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public String[] getAttributeNames() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren() throws InvalidRegistryObjectException {
            return null;
        }

        public IConfigurationElement[] getChildren(String name) throws InvalidRegistryObjectException {
            return null;
        }

        public IContributor getContributor() throws InvalidRegistryObjectException {
            return null;
        }

        public IExtension getDeclaringExtension() throws InvalidRegistryObjectException {
            return null;
        }

        public String getName() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespace() throws InvalidRegistryObjectException {
            return null;
        }

        public String getNamespaceIdentifier() throws InvalidRegistryObjectException {
            return null;
        }

        public Object getParent() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValue() throws InvalidRegistryObjectException {
            return null;
        }

        public String getValueAsIs() throws InvalidRegistryObjectException {
            return null;
        }

        public boolean isValid() {
            return false;
        }
    }
}

