/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newproject;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.operation.project.NewBsiCaseGroupStep1Operation;
import org.eclipse.scout.sdk.operation.project.NewScoutProjectStep2Operation;
import org.eclipse.scout.sdk.operation.template.ITemplateVariableSet;
import org.eclipse.scout.sdk.operation.template.TemplateVariableSet;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.bundletree.CheckableTree;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.wizard.AbstractWizardPage;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectTemplateWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScoutProjectNewWizardPage
extends AbstractWizardPage {
    static final int TYPE_BUNDLE_SWING = 100;
    static final int TYPE_BUNDLE_SWT = 101;
    static final int TYPE_BUNDLE_CLIENT = 102;
    static final int TYPE_BUNDLE_SHARED = 103;
    static final int TYPE_BUNDLE_SERVER = 104;
    private String m_projectName;
    private String m_postFix;
    private boolean m_createUiSwing;
    private boolean m_createUiSwt;
    private boolean m_createClient;
    private boolean m_createShared;
    private boolean m_createServer;
    private String m_projectAlias;
    private StyledTextField m_projectNameField;
    private StyledTextField m_postFixField;
    private CheckableTree m_bundleTree;
    private ITreeNode m_invisibleRootNode;
    private StyledTextField m_projectAliasNameField;

    public ScoutProjectNewWizardPage() {
        super(ScoutProjectNewWizardPage.class.getName());
        this.setTitle("Create a Scout Project");
        this.setDescription("Create a Scout project in the workspace.\nEnter the name and choose the desired tiers.");
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_projectNameField = this.getFieldToolkit().createStyledTextField(parent, "Project Name");
        this.m_projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.m_projectName = ScoutProjectNewWizardPage.this.m_projectNameField.getText();
                    ScoutProjectNewWizardPage.this.updateBundleNames();
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_postFixField = this.getFieldToolkit().createStyledTextField(parent, "Project Postfix");
        this.m_postFixField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ScoutProjectNewWizardPage.this.setStateChanging(true);
                    ScoutProjectNewWizardPage.this.m_postFix = ScoutProjectNewWizardPage.this.m_postFixField.getText();
                    ScoutProjectNewWizardPage.this.updateBundleNames();
                }
                finally {
                    ScoutProjectNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_invisibleRootNode = this.buildBundleTree();
        this.m_bundleTree = new CheckableTree(parent, this.m_invisibleRootNode);
        this.m_bundleTree.setChecked(TreeUtility.findNodes(this.m_invisibleRootNode, new P_InitialCheckNodesFilter()));
        this.m_bundleTree.addCheckSelectionListener(new ICheckStateListener(){

            @Override
            public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
                switch (node.getType()) {
                    case 102: {
                        ScoutProjectNewWizardPage.this.m_createClient = checkState;
                        ((ScoutProjectTemplateWizardPage)ScoutProjectNewWizardPage.this.getWizard().getPage(ScoutProjectTemplateWizardPage.class.getName())).refreshList();
                        break;
                    }
                    case 103: {
                        ScoutProjectNewWizardPage.this.m_createShared = checkState;
                        break;
                    }
                    case 104: {
                        ScoutProjectNewWizardPage.this.m_createServer = checkState;
                        break;
                    }
                    case 100: {
                        ScoutProjectNewWizardPage.this.m_createUiSwing = checkState;
                        break;
                    }
                    case 101: {
                        ScoutProjectNewWizardPage.this.m_createUiSwt = checkState;
                    }
                }
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        Control aliasGroup = this.createAliasGroup(parent);
        this.m_projectNameField.setFocus();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_projectNameField.setLayoutData(new GridData(768));
        this.m_postFixField.setLayoutData(new GridData(768));
        this.m_bundleTree.setLayoutData(new GridData(1808));
        aliasGroup.setLayoutData((Object)new GridData(768));
    }

    private ITreeNode buildBundleTree() {
        TreeNode rootNode = new TreeNode(-1, "root");
        rootNode.setVisible(false);
        TreeUtility.createNode(rootNode, 100, "ui.swing", ScoutSdkUi.getImageDescriptor("uiBundle.png"), 100L);
        TreeUtility.createNode(rootNode, 101, "ui.swt", ScoutSdkUi.getImageDescriptor("uiBundle.png"), 101L);
        TreeUtility.createNode(rootNode, 102, "client", ScoutSdkUi.getImageDescriptor("clientBundle.png"), 102L);
        TreeUtility.createNode(rootNode, 103, "shared", ScoutSdkUi.getImageDescriptor("sharedBundle.png"), 103L);
        TreeUtility.createNode(rootNode, 104, "server", ScoutSdkUi.getImageDescriptor("serverBundle.png"), 104L);
        return rootNode;
    }

    private void updateBundleNames() {
        String postfix = "";
        String pf = this.getPostFix();
        if (!StringUtility.isNullOrEmpty((String)pf)) {
            postfix = "." + pf;
        }
        TreeUtility.findNode(this.m_invisibleRootNode, NodeFilters.getByType(102)).setText(String.valueOf(this.getProjectName()) + ".client" + postfix);
        TreeUtility.findNode(this.m_invisibleRootNode, NodeFilters.getByType(103)).setText(String.valueOf(this.getProjectName()) + ".shared" + postfix);
        TreeUtility.findNode(this.m_invisibleRootNode, NodeFilters.getByType(104)).setText(String.valueOf(this.getProjectName()) + ".server" + postfix);
        TreeUtility.findNode(this.m_invisibleRootNode, NodeFilters.getByType(100)).setText(String.valueOf(this.getProjectName()) + ".ui.swing" + postfix);
        TreeUtility.findNode(this.m_invisibleRootNode, NodeFilters.getByType(101)).setText(String.valueOf(this.getProjectName()) + ".ui.swt" + postfix);
        this.m_bundleTree.getTreeViewer().refresh();
        String alias = "";
        int dotIndex = this.getProjectName().lastIndexOf(46);
        if (dotIndex > 0 && dotIndex < this.getProjectName().length() - 1) {
            alias = this.getProjectName().substring(dotIndex + 1);
        }
        if (pf != null && pf.length() > 1) {
            alias = String.valueOf(alias) + Character.toUpperCase(pf.charAt(0)) + pf.substring(1);
        }
        this.m_projectAliasNameField.setText(alias);
    }

    private Control createAliasGroup(Composite parent) {
        Group group = new Group(parent, 4);
        group.setText("Project Alias");
        Label label = new Label((Composite)group, 0);
        label.setText("The project alias is used for the servlet name and launcher names.");
        this.m_projectAliasNameField = this.getFieldToolkit().createStyledTextField((Composite)group, "Project Alias");
        this.m_projectAliasNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScoutProjectNewWizardPage.this.m_projectAlias = ScoutProjectNewWizardPage.this.m_projectAliasNameField.getText();
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        label.setLayoutData((Object)new GridData(768));
        this.m_projectAliasNameField.setLayoutData(new GridData(768));
        return group;
    }

    public void performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws IllegalArgumentException, CoreException {
        TemplateVariableSet variables = TemplateVariableSet.createNew((String)this.getProjectName(), (String)this.getPostFix(), (String)this.getProjectAlias());
        NewBsiCaseGroupStep1Operation op1 = new NewBsiCaseGroupStep1Operation(variables);
        op1.setCreateUiSwing(this.isCreateUiSwing());
        op1.setCreateUiSwt(this.isCreateUiSwt());
        op1.setCreateClient(this.isCreateClient());
        op1.setCreateShared(this.isCreateShared());
        op1.setCreateServer(this.isCreateServer());
        op1.setProjectName(this.getProjectName());
        op1.setProjectNamePostfix(this.getPostFix());
        op1.setProjectAlias(this.getProjectAlias());
        op1.validate();
        op1.run(monitor, workingCopyManager);
        NewScoutProjectStep2Operation op2 = new NewScoutProjectStep2Operation(op1, (ITemplateVariableSet)variables);
        op2.validate();
        op2.run(monitor, workingCopyManager);
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusProjectName());
        multiStatus.add(this.getStatusProjectAlias());
        multiStatus.add(this.getStatusUiBundles());
        multiStatus.add(this.getStatusClientBundle());
    }

    protected IStatus getStatusProjectName() {
        if (StringUtility.isNullOrEmpty((String)this.getProjectName())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Project name is not set.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusProjectAlias() {
        if (StringUtility.isNullOrEmpty((String)this.getProjectAlias())) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Project alias is not set.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusUiBundles() {
        if (!this.m_createClient) {
            if (this.isCreateUiSwing()) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "A swing bundle without a client boundle can not be created.");
            }
            if (this.isCreateUiSwt()) {
                return new Status(4, "org.eclipse.scout.sdk.ui", "A swt bundle without a client boundle can not be created.");
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusClientBundle() {
        if (this.isCreateClient() && !this.isCreateShared()) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "A client bundle without a shared bundle can not be created.");
        }
        return Status.OK_STATUS;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    public String getPostFix() {
        return this.m_postFix;
    }

    public void setPostFix(String postFix) {
        this.m_postFix = postFix;
    }

    public void setProjectAlias(String projectAlias) {
        this.m_projectAlias = projectAlias;
    }

    public String getProjectAlias() {
        return this.m_projectAlias;
    }

    public boolean isCreateUiSwing() {
        return this.m_createUiSwing;
    }

    public void setCreateUiSwing(boolean createUiSwing) {
        this.m_createUiSwing = createUiSwing;
    }

    public boolean isCreateUiSwt() {
        return this.m_createUiSwt;
    }

    public void setCreateUiSwt(boolean createUiSwt) {
        this.m_createUiSwt = createUiSwt;
    }

    public boolean isCreateClient() {
        return this.m_createClient;
    }

    public void setCreateClient(boolean createClient) {
        this.m_createClient = createClient;
    }

    public boolean isCreateShared() {
        return this.m_createShared;
    }

    public void setCreateShared(boolean createShared) {
        this.m_createShared = createShared;
    }

    public boolean isCreateServer() {
        return this.m_createServer;
    }

    public void setCreateServer(boolean createServer) {
        this.m_createServer = createServer;
    }

    private class P_InitialCheckNodesFilter
    implements ITreeNodeFilter {
        private P_InitialCheckNodesFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            switch (node.getType()) {
                case 102: {
                    ScoutProjectNewWizardPage.this.m_createClient = true;
                    return true;
                }
                case 103: {
                    ScoutProjectNewWizardPage.this.m_createShared = true;
                    return true;
                }
                case 104: {
                    ScoutProjectNewWizardPage.this.m_createServer = true;
                    return true;
                }
                case 100: {
                    ScoutProjectNewWizardPage.this.m_createUiSwing = true;
                    return true;
                }
                case 101: {
                    ScoutProjectNewWizardPage.this.m_createUiSwt = true;
                    return true;
                }
            }
            return false;
        }
    }
}

